<?php
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");

include("include/dbcommon.php");

// ✅ Block access to menu.php unless logged in
if (!isLogged()) {
    HeaderRedirect("login.php");
    exit();
}
?>
<!DOCTYPE html>
<html {$html_attrs}>
<head>
   
<meta http-equiv="X-UA-Compatible" content="IE=Edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{$pagetitle}</title>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  <base href="{$projectPath}">
  <link REL="stylesheet" href="styles/default.css?{$wizardBuildKey}" type="text/css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
  <link rel="stylesheet" href="chat-widget.css"> <!-- Optional -->
  <script src="live-chat.js"></script> <!-- Required for chat logic -->

  {BEGIN rtlCSS}
  <link REL="stylesheet" href="styles/defaultRTL.css?{$wizardBuildKey}" type="text/css">
  {END rtlCSS}
 
  <style>
/* ===================================================================
   GLOBAL STYLES
=================================================================== */
body {
font-family: Arial, sans-serif;
background: #f8f9fa;
margin: 0;
padding: 10px 0 0;
}

/* ===================================================================
   HEADER + NAVIGATION
=================================================================== */
header,
.custom-navbar {
background: #1E1E1E;
color: white;
backdrop-filter: blur(5px);
font-family: Arial, sans-serif;
}

header {
padding: 20px;
text-align: center;
position: sticky;
top: 60px;
z-index: 999;
transition: box-shadow 0.3s ease;
}

header.shrink {
padding: 10px 20px;
}

header.shadow {
box-shadow: 0 4px 8px rgba(0,0,0,0.2);
}

header.hidden {
transform: translateY(-100%);
}

.custom-navbar {
display: flex;
justify-content: space-between;
align-items: center;
padding: 10px 20px;
position: sticky;
top: 0;
z-index: 1000;
transition: box-shadow 0.3s ease;
}


/* ===================================================================
   PROFILE DROPDOWN
=================================================================== */
.profile-wrapper {
position: absolute;
top: 20px;
right: 30px;
z-index: 1000;
}

.profile-btn, .dropdown-btn {
background-color: transparent;
color: #ffffff;
font-weight: bold;
border: none;
font-size: 14px;
cursor: pointer;
}

.dropdown-content {
display: none;
position: absolute;
right: 0;
background-color: white;
min-width: 160px;
border-radius: 6px;
box-shadow: 0px 8px 16px rgba(0,0,0,0.2);
z-index: 9999;
color: #333;
}

.dropdown-content a {
color: #004080;
padding: 12px 16px;
text-decoration: none;
display: block;
font-size: 14px;
}

.dropdown-content a:hover {
background-color: #f1f1f1;
}

.show {
display: block;
}

/* ===================================================================
   LOGO + NAVIGATION LINKS
=================================================================== */
.logo {
height: 100px;
transition: transform 0.3s ease, height 0.3s ease;
}

.logo.shrink {
transform: scale(0.8);
height: 50px;
}

.brand-title {
font-size: 18px;
font-weight: bold;
color: #fff;
}

.nav-left {
display: flex;
align-items: center;
}

.nav-center a {
margin: 0 12px;
color: #fff;
text-decoration: none;
font-weight: 500;
}

.nav-center a:hover {
text-decoration: underline;
}

.nav-right {
position: relative;
}

/* ===================================================================
   CHART SECTION
=================================================================== */

.chart-row {
width: 100%;
background: #fff;
padding: 40px 20px;
box-shadow: 0 2px 8px rgba(0,0,0,0.05);
margin-bottom: 40px;
transition: max-height 0.5s ease, opacity 0.5s ease;
overflow: hidden;
}

.chart-container {
max-width: 1200px;
margin: auto;
}

.chart-row.hidden {
max-height: 0;
opacity: 0;
padding: 0 !important;
margin-bottom: 0 !important;
}

.toggle-chart-btn {
background-color: #dc3545;
color: white;
border: none;
padding: 6px 12px;
font-size: 14px;
border-radius: 4px;
cursor: pointer;
margin-right: 10px;
}
   
.toggle-chart-btn:hover {
background-color: #c82333;
}
   
/* ===================================================================
   JOB CARD STYLES
=================================================================== */  
/* ================= JOB CARD BACKGROUND LOGO STYLES ================= */

.job-card {
  position: relative;
  overflow: hidden;
}

/* 🔁 Shared ::before layout for all logos */
.job-card::before {
  content: "";
  position: absolute;
  bottom: 0;
  right: 0;
  width: 100%;
  height: 100%;
  z-index: 1;
  background-position: bottom right;
  background-repeat: no-repeat;
  background-size: 100px auto;
  pointer-events: none;
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.95), rgba(255,255,255,0)),
    url('images/logos/default.png'); /* fallback */
}

/* ✅ Logo overrides */
.card-sprep::before {
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.5), rgba(255,255,255,0)),
    url('images/logos/sprep_logo.png');
    background-size: 60px auto; /* 👈 adjust logo size */
}

.card-govt::before {
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.5), rgba(255,255,255,0)),
    url('images/logos/govt.png');
    background-size: 50px auto; /* 👈 adjust logo size */
}

.card-undp::before {
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.5), rgba(255,255,255,0)),
    url('images/logos/undp.png');
    background-size: 60px auto; /* 👈 adjust logo size */
}

.card-spc::before {
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.5), rgba(255,255,255,0)),
    url('images/logos/spc.png');
    background-size: 60px auto; /* 👈 adjust logo size */
}

.card-pifs::before {
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.5), rgba(255,255,255,0)),
    url('images/logos/pifs.png');
    background-size: 60px auto; /* 👈 adjust logo size */
}

.card-ffa::before {
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.5), rgba(255,255,255,0)),
    url('images/logos/ffa.png');
    background-size: 70px auto; /* 👈 adjust logo size */
}

.card-himalayas::before {
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.6), rgba(255,255,255,0)),
    url('images/logos/himalayas.png');
}

/* 🌙 Dark mode with logo and soft dark gradient */
body.dark-mode .card-sprep::before {
  background-image:
    linear-gradient(to top left, rgba(0,0,0,0.9), rgba(0,0,0,0)),
    url('images/logos/sprep_logo.png');
}

body.dark-mode .card-govt::before {
  background-image:
    linear-gradient(to top left, rgba(0,0,0,0.9), rgba(0,0,0,0)),
    url('images/logos/govt.png');
}

body.dark-mode .card-undp::before {
  background-image:
    linear-gradient(to top left, rgba(0,0,0,0.9), rgba(0,0,0,0)),
    url('images/logos/undp.png');
}

body.dark-mode .card-spc::before {
  background-image:
    linear-gradient(to top left, rgba(0,0,0,0.9), rgba(0,0,0,0)),
    url('images/logos/spc.png');
}

body.dark-mode .card-pifs::before {
  background-image:
    linear-gradient(to top left, rgba(0,0,0,0.9), rgba(0,0,0,0)),
    url('images/logos/pifs.png');
}

body.dark-mode .card-ffa::before {
  background-image:
    linear-gradient(to top left, rgba(0,0,0,0.9), rgba(0,0,0,0)),
    url('images/logos/ffa.png');
}

body.dark-mode .card-himalayas::before {
  background-image:
    linear-gradient(to top left, rgba(0,0,0,0.9), rgba(0,0,0,0)),
    url('images/logos/himalayas.png');
}


.card-sprep:hover::before,
.card-govt:hover::before,
.card-undp:hover::before,
.card-spc:hover::before,
.card-pifs:hover::before,
.card-ffa:hover::before,
.card-himalayas:hover::before {
  opacity: 0.08;
  filter: saturate(1.1) brightness(1.5);
}

/* 🔺 Top-left triangle tag (uses ::after so it doesn't conflict with ::before logos) */
.job-card::after {
  content: "";
  position: absolute;
  top: 0;
  left: 0;
  width: 0;
  height: 0;
  border-style: solid;
  border-width: 0 28px 28px 0;
  border-color: transparent #f59e0b transparent transparent; /* Default FFA orange */
  z-index: 3;
  border-radius: 0 0 4px 0;
  box-shadow: 0 2px 4px rgba(0,0,0,0.2);
}


/* 🌐 Source-specific triangle colors */
.card-govt::after { border-color: transparent #3b82f6 transparent transparent; } /* Blue */
.card-sprep::after { border-color: transparent #10b981 transparent transparent; } /* Green */
.card-undp::after { border-color: transparent #6366f1 transparent transparent; } /* Indigo */
.card-spc::after { border-color: transparent #0ea5e9 transparent transparent; } /* Sky */
.card-pifs::after { border-color: transparent #ec4899 transparent transparent; } /* Pink */
.card-ffa::after { border-color: transparent #f59e0b transparent transparent; } /* Amber */
.card-himalayas::after { border-color: transparent #8b5cf6 transparent transparent; } /* Violet */

/* 🌙 Optional dark mode refinement */
body.dark-mode .job-card::after {
  opacity: 0.85;
}







/* ✅ Grace period tag - Light mode */
.grace-message {
  display: inline-block;
  background-color: #fff3cd; /* soft warning yellow */
  color: #856404;
  border: 1px solid #ffeeba;
  padding: 6px 10px;
  border-radius: 6px;
  font-size: 13px;
  margin-top: 6px;
}

/* 🌙 Dark mode override */
body.dark-mode .grace-message {
  background-color: rgba(255, 193, 7, 0.1); /* subtle dark amber */
  color: #ffc107; /* warm yellow text */
  border: 1px solid rgba(255, 193, 7, 0.3);
  backdrop-filter: blur(2px);
}



.badge-closing-inline {
  display: inline-block;
  padding: 2px 8px;
  font-size: 11px;
  border-radius: 4px;
  margin-left: 8px;
  font-weight: bold;
  vertical-align: middle;
}

.urgent-red {
  background-color: #dc3545;
  color: #fff;
}

.closing-soon-animated {
  background: #fdecea;
  color: #b91c1c;
  padding: 5px 10px;
  border-radius: 5px;
  font-size: 0.85em;
  display: inline-block;
  margin-top: 4px;
  font-weight: 500;
}

.closing-soon-animated:hover {
  transform: translateY(-2px) scale(1.05);
  font-size: 14px;
}

.expired-tag {
  margin-left: 6px;
  color: #6c757d;
  background-color: #e2e3e5;
  font-size: 13px;
  font-weight: bold;
  padding: 4px 8px;
  border-radius: 4px;
}

.expired-card {
  opacity: 0.6;
  filter: grayscale(20%);
/*  pointer-events: none;  optional: disable clicks */
}

.grace-message {
  display: inline-block;
  margin-left: 6px;
  font-size: 13px;
  color: #856404;
  background-color: #fff3cd;
  border-left: 4px solid #fd7e14;
  padding: 4px 8px;
  border-radius: 4px;
}


.no-local-jobs {
  background: #fff6f6;
  border: 1px solid #f5c2c7;
  color: #842029;
  padding: 20px 30px;
  border-radius: 12px;
  text-align: center;
  box-shadow: 0 2px 6px rgba(0,0,0,0.05);
  font-family: 'Segoe UI', sans-serif;
  max-width: 700px;
  margin: 40px auto;
  position: relative;
  transition: all 0.4s ease-in-out;
}

.dismiss-btn {
  position: absolute;
  top: 10px;
  right: 15px;
  border: none;
  background: transparent;
  font-size: 18px;
  color: #d63384;
  cursor: pointer;
  transition: opacity 0.3s;
}
.dismiss-btn:hover {
  opacity: 0.6;
}


.no-local-jobs h3 {
  font-size: 1.5rem;
  color: #d63384;
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 8px;
}

.no-local-jobs p {
  font-size: 1rem;
  line-height: 1.5;
  margin-top: 10px;
}






.jobs-grid {
display: flex;
flex-wrap: wrap;
gap: 20px;
justify-content: center;
padding: 40px 20px;
}
   
.job-card {
background: #fff;
border-radius: 10px;
box-shadow: 0 4px 10px rgba(0,0,0,0.1);
padding: 20px;
width: 280px;
border-left: 5px solid #007BFF;
position: relative;
z-index: 2;
transition: all 0.3s ease;
overflow: hidden;
min-height: 180px;
}

.job-card:hover {
transform: translateY(-8px);
box-shadow: 0 8px 20px rgba(0,0,0,0.2);
}

.job-description {
opacity: 0;
max-height: 0;
overflow: hidden;
transition: all 0.3s ease;
font-size: 13px;
color: #444;
margin-top: 10px;
}

.job-card:hover .job-description {
opacity: 1;
max-height: 150px;
}

/* ✅ Light mode gradient style */
/* Gradient from Coral to Blue */
/*.job-card h3 {
  background: linear-gradient(90deg, #ff7f50, #1e90ff); 
  -webkit-background-clip: text;
  color: transparent;
  font-size: 18px;
  font-weight: 600;
  margin-bottom: 10px;
}*/

/* 🌙 Dark mode gradient style (with a slight brightness boost) */
body.dark-mode .job-card h3 {
  background: linear-gradient(90deg, #ff7f50, #1e90ff); /* Same gradient */
  -webkit-background-clip: text;
  color: transparent;
  font-size: 18px;
  font-weight: 600;
  margin-bottom: 10px;
  opacity: 1; /* Fix opacity issue in dark mode */
}


.job-card p {
margin: 4px 0;
font-size: 14px;
}


.dropdown-btn {
  background: transparent;
  border: none;
  color: white;
  font-size: 14px;
  cursor: pointer;
}

.dropdown-content {
  display: none;
  position: absolute;
  right: 0;
  background-color: white;
  color: #333;
  min-width: 180px;
  border-radius: 6px;
  box-shadow: 0 8px 16px rgba(0,0,0,0.15);
  z-index: 9999;
}

.dropdown-content a {
  color: #004080;
  padding: 12px 16px;
  text-decoration: none;
  display: block;
}

.dropdown-content a:hover {
  background-color: #f1f1f1;
}

.show {
  display: block;
}




.filter-btn {
  background-color: #f8f9fa;
  color: #333;
  border: 1px solid #ccc;
  padding: 8px 16px;
  border-radius: 20px;
  font-size: 14px;
  cursor: pointer;
  transition: background-color 0.3s ease, transform 0.2s ease;
  display: inline-block;
  font-weight: 500;
  min-width: 120px;
  text-align: center;
}

.filter-btn:hover {
  background-color: #e2e6ea;
  transform: translateY(-2px);
}

 
  .filter-btn.red { background-color: #dc3545; color: white; }
.filter-btn.red:hover { background-color: #c82333; }

.filter-btn.blue { background-color: #007BFF; color: white; }
.filter-btn.blue:hover { background-color: #0056b3; }

.filter-btn.green { background-color: #28a745; color: white; }
.filter-btn.green:hover { background-color: #1e7e34; }

.filter-btn.purple { background-color: #6f42c1; color: white; }
.filter-btn.purple:hover { background-color: #563d7c; }

  .btn-blue {
    background-color: #007BFF;
    color: white;
    border-color: #007BFF;
  }

  .btn-green {
    background-color: #28a745;
    color: white;
    border-color: #28a745;
  }

  .btn-purple {
    background-color: #6f42c1;
    color: white;
    border-color: #6f42c1;
  }

  .btn-blue:hover {
    background-color: #0056b3;
  }

  .btn-green:hover {
    background-color: #1e7e34;
  }

  .btn-purple:hover {
    background-color: #563d7c;
  }

    /* popup modal styles start */
      #customModal {
      display: none;
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: rgba(0,0,0,0.6);
      z-index: 9999;
      align-items: center;
      justify-content: center;
    }
    .modal-content {
      background: white;
      padding: 30px;
      border-radius: 14px;
      max-width: 1100px;
      width: 95%;
      position: relative;
      height: 90vh;
      overflow: hidden;
      display: flex;
      flex-direction: column;
      box-shadow: 0 10px 40px rgba(0,0,0,0.25);
      animation: slideIn 0.3s ease-out;
    }
    .modal-content iframe {
      /*flex: 1;*/
      width: 100%;
      border: none;
    }
    .modal-close {
      position: absolute;
      top: 10px;
      right: 10px;
      background: #e74c3c;
      border: none;
      color: white;
      padding: 8px 12px;
      cursor: pointer;
      border-radius: 6px;
      font-size: 16px;
      z-index: 10;
    }
    @keyframes slideIn {
      from { transform: translateY(-30px); opacity: 0; }
      to { transform: translateY(0); opacity: 1; }
    }
   
    .load-more-container {
      text-align: center;
      margin-bottom: 40px;
    }
    .load-more-btn {
      padding: 10px 20px;
      font-size: 14px;
      background-color: #007BFF;
      color: white;
      border: none;
      border-radius: 6px;
      cursor: pointer;
    }
    .load-more-btn:hover {
      background-color: #0056b3;
    }
   
   
     /* Make UI Mobile-Friendly */
    @media (max-width: 600px) {
  .dashboard, .jobs-grid {
    flex-direction: column;
    align-items: center;
  }
  .card, .job-card {
    width: 100%;
    max-width: 90%;
  }
}

.custom-navbar {
  display: flex;
  justify-content: space-between;
  align-items: center;
  background-color: #1E1E1E;
  color: white;
  padding: 10px 20px;
  font-family: Arial, sans-serif;

  /* Sticky behavior */
  position: sticky;
  top: 0;
  z-index: 1000;
 
  transition: box-shadow 0.3s ease;
}
 
 
 .apply-now-btn {
  position: absolute;
  top: 10px;
  right: 10px;
  background-color: #28a745;
  color: white;
  font-size: 13px;
  padding: 6px 10px;
  border-radius: 5px;
  text-decoration: none;
  z-index: 10;
}
.apply-now-btn:hover {
  background-color: #218838;
}


.toggle-desc {
  display: inline-block;
  margin-left: 8px;
  color: #007BFF;
  cursor: pointer;
  font-size: 13px;
}
.toggle-desc:hover {
  text-decoration: underline;
}





  .guest-slide-popup {
    position: fixed;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    background: #f9f9ff;
    border-left: 4px solid #007BFF;
    border-radius: 10px;
    padding: 20px 20px 15px;
    width: 90%;
    max-width: 360px;
    box-shadow: 0 6px 20px rgba(0,0,0,0.15);
    z-index: 9999;
    animation: slideInUp 0.5s ease;
  }
  .guest-popup-content h3 {
    margin: 0 0 8px;
    font-size: 16px;
    color: #007BFF;
  }
  .guest-popup-content p {
    font-size: 14px;
    margin: 4px 0;
  }
  .guest-popup-buttons {
    margin-top: 10px;
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
  }
  .guest-popup-buttons button {
    background-color: #007BFF;
    color: white;
    border: none;
    padding: 6px 12px;
    font-size: 13px;
    border-radius: 5px;
    cursor: pointer;
    /*flex: 1;*/
  }
  .guest-popup-buttons button:hover {
    background-color: #0056b3;
  }
  .guest-popup-close {
    position: absolute;
    top: 8px;
    right: 12px;
    font-size: 18px;
    background: none;
    border: none;
    cursor: pointer;
    color: #666;
  }
  @keyframes slideInUp {
    from { transform: translate(-50%, calc(-50% + 30px)); opacity: 0; }
    to { transform: translate(-50%, -50%); opacity: 1; }
  }
 
   .guest-slide-popup {
    position: fixed;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    background: #f9f9ff;
    border-left: 4px solid #007BFF;
    border-radius: 10px;
    padding: 20px 20px 15px;
    width: 90%;
    max-width: 360px;
    box-shadow: 0 6px 20px rgba(0,0,0,0.15);
    z-index: 9999;
    animation: slideInUp 0.5s ease;
  }
  .guest-popup-content h3 {
    margin: 0 0 8px;
    font-size: 16px;
    color: #007BFF;
  }
  .guest-popup-content p {
    font-size: 14px;
    margin: 4px 0;
  }
  .guest-popup-buttons {
    margin-top: 10px;
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
  }
  .guest-popup-buttons button {
    background-color: #007BFF;
    color: white;
    border: none;
    padding: 6px 12px;
    font-size: 13px;
    border-radius: 5px;
    cursor: pointer;
    /*flex: 1;*/
  }
  .guest-popup-buttons button:hover {
    background-color: #0056b3;
  }
  .guest-popup-close {
    position: absolute;
    top: 8px;
    right: 12px;
    font-size: 18px;
    background: none;
    border: none;
    cursor: pointer;
    color: #666;
  }
  @keyframes slideInUp {
    from { transform: translate(-50%, calc(-50% + 30px)); opacity: 0; }
    to { transform: translate(-50%, -50%); opacity: 1; }
  }
 
 
 
 
 

  .apply-message-popup {
      position: absolute;
      top: 40px;
      right: 10px;
      background: #fff;
      border: 1px solid #ccc;
      border-left: 4px solid #28a745;
      padding: 10px;
      border-radius: 8px;
      font-size: 13px;
      box-shadow: 0 4px 10px rgba(0,0,0,0.1);
      display: none;
      z-index: 999;
      width: 220px;
    }
   
   
  .apply-message-popup button {
      margin-top: 8px;
      padding: 6px 10px;
      background: #28a745;
      color: white;
      border: none;
      border-radius: 4px;
      font-size: 12px;
      cursor: pointer;
    }

    /* Modal backdrop */
  #remoteJobModal {
    display: none;
    position: fixed;
    z-index: 9999;
    top: 0; left: 0;
    width: 100%; height: 100%;
    background: rgba(0, 0, 0, 0.6);
    align-items: center;
    justify-content: center;
  }

  /* Modal content box */
  #remoteJobModal .modal-content {
    position: relative;
    width: 90%;
    max-width: 900px;
    height: 80vh;
    background: #fff;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 4px 16px rgba(0,0,0,0.3);
  }

  /* Close button */
  #remoteJobModal .modal-close {
    position: absolute;
    top: 8px; right: 12px;
    background: #e74c3c;
    color: #fff;
    border: none;
    border-radius: 50%;
    width: 30px; height: 30px;
    font-size: 18px;
    cursor: pointer;
    z-index: 10;
    line-height: 30px;
    text-align: center;
  }

  /* Iframe styling */
  #remoteJobModal iframe {
    width: 100%;
    height: 100%;
    border: none;
  }
   
   /* ─────────────────────────────────────────────────────────────────────────────
   Style for the “View Job” button on remote job cards
   ───────────────────────────────────────────────────────────────────────────── */
.view-job-btn {
  background-color: #007bff;
  color: white;
  padding: 6px 12px;
  border-radius: 6px;
  display: inline-block;
  text-decoration: none;
}
.view-job-btn:hover {
  background-color: #0056b3;
}


.page-link.active {
  background-color: #0056b3;
  font-weight: bold;
}


#externalJobs {
  transition: opacity 0.3s ease-in-out;
}


.loader {
  text-align: center;
  font-weight: bold;
  font-size: 18px;
  margin-top: 20px;
}
.loader .dot {
  animation: dotBlink 1.5s infinite;
}
.loader .dot:nth-child(2) {
  animation-delay: 0.2s;
}
.loader .dot:nth-child(3) {
  animation-delay: 0.4s;
}

@keyframes dotBlink {
  0%, 20% { opacity: 0; }
  50% { opacity: 1; }
  100% { opacity: 0; }
}


.dot-loader {
  display: flex;
  justify-content: center;
  align-items: center;
  margin: 30px auto;
  height: 40px;
  gap: 8px;
}

.dot-loader span {
  width: 12px;
  height: 12px;
  background-color: #007bff;
  border-radius: 50%;
  animation: dotBounce 1.2s infinite ease-in-out;
}

.dot-loader span:nth-child(1) {
  animation-delay: 0s;
}
.dot-loader span:nth-child(2) {
  animation-delay: 0.2s;
}
.dot-loader span:nth-child(3) {
  animation-delay: 0.4s;
}

@keyframes dotBounce {
  0%, 80%, 100% {
    transform: scale(0.6);
    opacity: 0.3;
  }
  40% {
    transform: scale(1);
    opacity: 1;
  }
}
 
  .job-board-wrapper {
  display: flex;
  flex-direction: column;
  gap: 50px;
  padding: 20px;
  max-width: 1200px;
  margin: auto;
}

.board-section {
  background: #fff;
  border-radius: 12px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.05);
  padding: 20px;
}

.board-section h3 {
  margin-top: 0;
  font-size: 20px;
  color: #007BFF;
  border-left: 4px solid #007BFF;
  padding-left: 10px;
}

 .location-preview,
.location-full {
  display: inline;
}

/*--------------------------------------------------------------------------------------*/
/* 🌐 Floating Button with label */
.floating-disclaimer-trigger {
  display: none;
  position: fixed;
  padding: 8px 16px;
  background: #0d6efd;
  color: #fff;
  font-weight: bold;
  font-size: 14px;
  border-radius: 30px;
  cursor: pointer;
  box-shadow: 0 4px 12px rgba(0,0,0,0.2);
  z-index: 9999;
  transition: all 0.3s ease;
}

.floating-right-buttons {
  position: fixed;
  right: 20px;
  top: 240px;
  display: flex;
  flex-direction: column;
  gap: 10px;
  z-index: 9999;
}

.floating-right-buttons button,
.logout-btn {
  padding: 8px 16px;
  background-color: #007bff;
  color: white;
  font-size: 13px;
  border: none;
  border-radius: 20px;
  cursor: pointer;
  box-shadow: 0 2px 6px rgba(0,0,0,0.2);
  text-decoration: none;
  text-align: center;
}
.floating-right-buttons button:hover,
.logout-btn:hover {
  background-color: #0056b3;
}

.floating-panel {
  position: fixed;
  right: 20px;
  z-index: 9999;
  display: flex;
  flex-direction: column;
  align-items: flex-end;
  transition: all 0.3s ease;
}

/* Top position (desktop) */
@media (min-width: 768px) {
  .floating-panel {
    top: 140px;
  }
}

/* Bottom position (mobile) */
@media (max-width: 767px) {
  .floating-panel {
    bottom: 80px;
  }
}

.panel-toggle {
  background: #0d6efd;
  color: white;
  border: none;
  padding: 6px 14px;
  border-radius: 20px;
  font-size: 16px;
  cursor: pointer;
  box-shadow: 0 2px 6px rgba(0,0,0,0.2);
  margin-bottom: 8px;
}

.panel-buttons {
  display: none;
  flex-direction: column;
  gap: 8px;
  align-items: flex-end;
  animation: slideDown 0.3s ease-out;
}

.panel-buttons button,
.logout-btn {
  background: #007bff;
  color: white;
  padding: 8px 16px;
  border: none;
  border-radius: 20px;
  font-size: 13px;
  cursor: pointer;
  box-shadow: 0 2px 6px rgba(0,0,0,0.2);
  text-decoration: none;
}

.logout-btn:hover,
.panel-buttons button:hover {
  background: #0056b3;
}

.floating-panel.expanded .panel-buttons {
  display: flex;
}

@keyframes slideDown {
  from { opacity: 0; transform: translateY(-10px); }
  to   { opacity: 1; transform: translateY(0); }
}


/*ananei*/

/*.floating-disclaimer-trigger:hover {
  transform: scale(1.1);
}*/

/*.floating-disclaimer-trigger:hover {
  transform: scale(1.05);
  box-shadow: 0 6px 14px rgba(0,0,0,0.3);
}*/

/*.floating-disclaimer-trigger {
  display: inline-block;
  padding: 10px 16px;
  font-size: 14px;
  font-weight: bold;
  background: linear-gradient(to right, #007bff, #0056b3);
  color: #fff;
  border: none;
  border-radius: 999px;
  box-shadow: 0 4px 10px rgba(0,0,0,0.2);
  backdrop-filter: blur(8px);
  transition: all 0.3s ease;
}

.floating-disclaimer-trigger:hover {
  animation: pulseGlow 0.8s ease-out;
}*/

/*.floating-disclaimer-trigger {
  position: fixed;
  right: 20px;
  top: 50%;
  transform: translateY(-50%);
  width: 45px;
  height: 45px;
  background: linear-gradient(135deg, #007bff, #0056b3);
  color: white;
  font-size: 22px;
  font-weight: bold;
  text-align: center;
  line-height: 45px;
  border-radius: 50%;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
  cursor: pointer;
  z-index: 9999;
  transition: transform 0.3s ease, box-shadow 0.3s ease;
}*/

.floating-disclaimer-trigger:hover {
  transform: translateY(-50%) scale(1.1);
  box-shadow: 0 6px 16px rgba(0, 123, 255, 0.4);
}*/


@keyframes pulseGlow {
  0% { box-shadow: 0 0 0 rgba(0, 123, 255, 0.5); }
  50% { box-shadow: 0 0 15px rgba(0, 123, 255, 0.7); }
  100% { box-shadow: 0 0 0 rgba(0, 123, 255, 0); }
}

/* 📢 Popup centered in screen */
.disclaimer-popup-centered {
  display: none;
  position: fixed;
  top: 50%;
  left: 50%;
  width: 90%;
  max-width: 500px;
  background: #e7f3ff;
  color: #084298;
  border: 1px solid #b6d4fe;
  border-radius: 12px;
  padding: 20px;
  z-index: 9999;
  transform: translate(-50%, -50%);
  box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
}


/* 🗨️ Disclaimer Box */
.disclaimer-popup-box {
  display: none;
  position: fixed;
  bottom: 160px;
  right: 20px;
  width: 300px;
  max-width: 90%;
  background-color: #e7f3ff;
  color: #084298;
  border: 1px solid #b6d4fe;
  border-radius: 12px;
  box-shadow: 0 6px 20px rgba(0,0,0,0.1);
  padding: 20px;
  z-index: 9999;
}

.disclaimer-popup-centered h4 {
  margin-top: 0;
  font-size: 16px;
}

.disclaimer-popup-centered p {
  font-size: 13px;
  margin-bottom: 10px;
}

.disclaimer-popup-box p {
  font-size: 13px;
  margin-bottom: 10px;
}

/* 💻 Desktop Position: right center */
@media (min-width: 768px) {
  .floating-disclaimer-trigger {
    right: 20px;
    top: 50%;
    transform: translateY(-50%);
  }
}

/* 📱 Mobile Position: bottom right */
@media (max-width: 767px) {
  .floating-disclaimer-trigger {
    bottom: 80px;
    right: 20px;
    transform: none;
  }
}
 
 .disclaimer-settings-wrapper {
  display: flex;
  justify-content: center;
  align-items: center;
  margin: 40px auto;
  padding-bottom: 60px;
}

.disclaimer-settings-card {
  background-color: #f8f9fa;
  border: 1px solid #ddd;
  padding: 20px 30px;
  border-radius: 12px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.05);
  max-width: 400px;
  text-align: center;
}

.disclaimer-settings-card h5 {
  font-size: 16px;
  font-weight: bold;
  margin-bottom: 12px;
  color: #333;
}

.disclaimer-settings-card button {
  margin-top: 10px;
}

/*--------------------------------------------------------------------------*/

.highlight-top {
  animation: headerBounceGlow 0.8s ease;
  box-shadow: 0 0 12px rgba(0, 123, 255, 0.6);
}

@keyframes headerBounceGlow {
  0%   { transform: translateY(0); box-shadow: 0 0 0 rgba(0,123,255,0); }
  25%  { transform: translateY(-12px); }
  50%  { transform: translateY(0); box-shadow: 0 0 15px rgba(0,123,255,0.8); }
  75%  { transform: translateY(-6px); }
  100% { transform: translateY(0); box-shadow: 0 0 0 rgba(0,123,255,0); }
}

/*--------------------------------------------------------------------------*/
/* ✨ Bounce + Glow for job cards */
.job-card.highlight-card {
  animation: cardBounceGlow 0.8s ease;
  box-shadow: 0 0 12px rgba(40, 167, 69, 0.6); /* green glow */
}

@keyframes cardBounceGlow {
  0%   { transform: translateY(0); box-shadow: 0 0 0 rgba(40,167,69,0); }
  25%  { transform: translateY(-10px); }
  50%  { transform: translateY(0); box-shadow: 0 0 16px rgba(40,167,69,0.8); }
  75%  { transform: translateY(-4px); }
  100% { transform: translateY(0); box-shadow: 0 0 0 rgba(40,167,69,0); }
}

/*--------------------------------------------------------------------------*/

.alert-close-btn {
  position: absolute;
  top: 10px;
  right: 14px;
  background: transparent;
  border: none;
  padding: 4px;
  cursor: pointer;
  border-radius: 50%;
  transition: background-color 0.2s ease, transform 0.2s ease;
}

.alert-close-btn:hover {
  background-color: rgba(214, 51, 132, 0.1); /* Soft pink glow */
  transform: scale(1.1);
}

.alert-close-btn svg {
  display: block;
}
/*-------------------------------------------------------------------------12/06/2025-*/

.badge {
  display: inline-block;
  padding: 4px 8px;
  border-radius: 8px;
  font-size: 12px;
  margin: 2px;
}

.badge.active { background: #c8f7c5; color: #1a7f37; }
.badge.expired { background: #fddede; color: #d93025; }
.badge.archived { background: #e0e0e0; color: #555; }

.drag-icon {
  font-size: 12px;
  opacity: 0.5;
  cursor: move;
  user-select: none;
}

.drag-back {
  position: absolute;
  bottom: 6px;
  right: 8px;
}

/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/

/* ===================================================================
   DASHBOARD CARDS
=================================================================== */
.dashboard {
  display: flex;
  flex-wrap: wrap;
  gap: 12px;
  justify-content: center;
  padding: 10px;
  transition: all 0.3s ease;
}

.dashboard-toggle-btn {
  position: fixed;
  bottom: 0;
  left: 50%;
  transform: translateX(-50%);
  background: #b45309;
  color: white;
  padding: 10px 28px;
  border: none;
  border-top: 6px solid orange;
  font-weight: bold;
  border-radius: 12px 12px 0 0;
  box-shadow: 0 -4px 8px rgba(0,0,0,0.15);
  cursor: pointer;
  z-index: 999;
  transition: all 0.3s ease;
}

.dashboard-toggle-btn.top {
  position: relative;
  margin: 10px 8px;
  top: auto;
  left: auto;
  transform: none;
  border-radius: 6px;
  padding: 6px 16px;
  font-size: 13px;
  border-top: none;
  box-shadow: 0 2px 6px rgba(0,0,0,0.1);
  display: inline-block;
  background-color: #b45309;
  color: white;
}


.dashboard-hidden,
.dashboard-charts-hidden,
.dashboard-filters-hidden {
  display: none;
  position: relative;
}

#dashboardCharts,
#dashboardFilters {
  transition: all 0.3s ease;
}

.chart-container-user-posted {
  width: 100%;
  height: 300
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  position: relative;
  margin: 0 auto;
}

.chart-container-user-posted h4 {
  margin-bottom: 8px;
  font-size: 16px;
  text-align: center;
  color: #333;
}


.card {
  background: #ffffff;
  border-radius: 16px;
  box-shadow: 0 4px 10px rgba(0,0,0,0.08);
  padding: 16px;
  flex: 1 1 300px;
  max-width: 300px;
  min-width: 260px; /* ✅ Much more appropriate */
  text-align: center;
  transition: transform 0.2s ease, box-shadow 0.2s ease;
}

.card:hover {
  transform: translateY(-5px);
  box-shadow: 0 8px 16px rgba(0,0,0,0.15);
}

.card h4 {
  margin: 0 0 12px;
  color: #004080;
  font-size: 16px;
  font-weight: 600;
  text-transform: uppercase;
}

.card p {
  margin: 4px 0;
  font-size: 16px;
  font-weight: 500;
  color: #333;
}

.flip-card {
  perspective: 1000px;
  width: 260px;
  height: 280px;
  margin: 10px;
  border-radius: 16px;
  transition: transform 0.2s;
  position: relative;
}
.flip-card-inner {
  transition: transform 0.6s ease;
  transform-style: preserve-3d;
  position: relative;
  width: 100%;
  height: 100%;
}
.flip-card.pinned .flip-card-inner {
  transform: rotateY(180deg) !important;
}
.flip-card:hover .flip-card-inner:not(.pinned) {
  transform: rotateY(180deg);
}
.flip-card-front,
.flip-card-back {
  position: absolute;
  width: 100%;
  height: 100%;
  backface-visibility: hidden;
  border-radius: 16px;
  background: #fff;
  box-shadow: 0 6px 16px rgba(0,0,0,0.08);
  padding: 14px;
  box-sizing: border-box;
}
.flip-card-back {
  transform: rotateY(180deg);
}

.card-header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  gap: 6px;
  margin-bottom: 8px;
}
.job-source-icon {
  font-size: 18px;
}

.chart-center {
  width: 100%;
  height: 140px;
  position: relative;
  display: flex;
  justify-content: center;
  align-items: center;
}

.chart-center canvas {
  width: 100% !important;
  height: 100% !important;
}
.chart-legend-stats {
  font-size: 12px;
  padding-top: 8px;
}

.chart-legend-stats div {
  display: flex;
  align-items: center;
  gap: 6px;
  margin-bottom: 2px;
}
.chart-legend-stats span.dot {
  width: 10px;
  height: 10px;
  border-radius: 50%;
  display: inline-block;
}

.dot.active { background-color: #34a853; }
.dot.expired { background-color: #ea4335; }
.dot.archived { background-color: #9aa0a6; }
.card-description {
  font-size: 13px;
  color: #333;
  line-height: 1.5;
  margin-top: 20px;
}

.pin-control {
  text-align: right;
  font-size: 11px;
  display: flex;
  align-items: center;
  gap: 6px;
}

.pin-btn {
  background: none;
  border: none;
  font-size: 18px;
  cursor: pointer;
  margin-right: 4px;
}

.drag-icon {
  font-size: 14px;
  opacity: 0.6;
  cursor: move;
  margin-left: auto;
  user-select: none;
}

.nav-right .dropdown {
  display: inline-block;
  position: relative;
}

.nav-right .dropdown-btn {
  background: #007bff;
  color: #fff;
  border: none;
  padding: 8px 14px;
  border-radius: 5px;
  cursor: pointer;
}

.nav-right .dropdown-content {
  display: none;
  position: absolute;
  top: 110%;
  right: 0;
  background-color: #fff;
  min-width: 180px;
  box-shadow: 0 8px 16px rgba(0,0,0,0.2);
  border-radius: 8px;
  z-index: 1000;
  overflow: hidden;
}

.nav-right .dropdown-content a {
  padding: 10px 16px;
  display: block;
  color: #333;
  text-decoration: none;
  font-size: 14px;
}

.nav-right .dropdown-content a:hover {
  background-color: #f0f0f0;
}


.dropdown-menu-custom {
  display: none;
  position: absolute;
  right: 0;
  top: 120%;
  background: white;
  box-shadow: 0 8px 16px rgba(0,0,0,0.15);
  border-radius: 10px;
  z-index: 999;
  min-width: 180px;
  padding: 10px;
}

.dropdown-link {
  display: block;
  padding: 10px 14px;
  border-radius: 8px;
  margin-bottom: 6px;
  background-color: #f7f9fc;
  text-decoration: none;
  color: #333;
  transition: 0.3s ease;
}

.dropdown-link:hover {
  background-color: #e8f0fe;
  color: #000;
}

.dropdown-link.logout {
  background-color: #ffecec;
  color: #a00;
}

.dropdown-link.logout:hover {
  background-color: #f8d7da;
  color: #800;
}

  /* Your existing theme toggle CSS */
  #themeToggleWrapper {
    display: inline-block;
    margin-right: 10px;
    vertical-align: top;
  }

  #themeToggleBtn {
    font-size: 14px;
    padding: 5px 12px;
    height: 34px;
    border-radius: 4px;
    background-color: #ffffff;
    border: 1px solid #ccc;
    color: #333;
    cursor: pointer;
  }

  #themeToggleBtn.active {
    background-color: #212529;
    color: #fff;
    border-color: #212529;
  }

  body.dark-mode {
    background-color: #1e1e1e !important;
    color: #f1f1f1 !important;
  }

  body.dark-mode .panel,
  body.dark-mode .table,
  body.dark-mode .form-control,
  body.dark-mode .btn,
  body.dark-mode .rnr-page {
    background-color: #2c2c2c !important;
    color: #ddd !important;
    border-color: #555 !important;
  }

  body.dark-mode .form-control::placeholder {
    color: #aaa;
  }
  
  #themeToggleBtn {
  border-radius: 20px;
  padding: 6px 14px;
}

/* Ensure all text adjusts in dark mode */
body.dark-mode,
body.dark-mode p,
body.dark-mode h1,
body.dark-mode h2,
body.dark-mode h3,
body.dark-mode h4,
body.dark-mode h5,
body.dark-mode h6,
body.dark-mode a,
body.dark-mode span,
body.dark-mode strong,
body.dark-mode td,
body.dark-mode th {
  color: #f1f1f1 !important;
}

/* Improve contrast for semi-transparent text */
body.dark-mode .card-description,
body.dark-mode .desc-preview,
body.dark-mode .desc-full,
body.dark-mode .grace-message,
body.dark-mode .expired-tag {
  color: #ddd !important;
}

/* Adjust link/button contrast if needed */
body.dark-mode a,
body.dark-mode a:visited {
  color: #80caff !important;
}

/* Optional: Better readability on flip cards */
body.dark-mode .job-card,
body.dark-mode .flip-card-front,
body.dark-mode .flip-card-back {
  background-color: #2c2c2c !important;
  border-color: #444 !important;
}

body.dark-mode .btn,
body.dark-mode .btn-outline-light {
  background-color: #444 !important;
  color: #fff !important;
  border-color: #777 !important;
}

body.dark-mode h3[id^="section-"] {
  color: #00bfff !important;
}

/* 🔧 Dark mode: improve alert contrast */
body.dark-mode .alert,
body.dark-mode .alert-danger,
body.dark-mode .alert-warning,
body.dark-mode .alert-info {
  background-color: #2a2a2a !important;
  color: #f1f1f1 !important;
  border: 1px solid #555 !important;
}

/* 🔧 Dark mode: improve custom modal/dialog contrast */
body.dark-mode .custom-modal,
body.dark-mode .popup-box,
body.dark-mode .modal-content,
body.dark-mode .floating-panel,
body.dark-mode .panel-box,
body.dark-mode .transparency-notice {
  background-color: #2c2c2c !important;
  color: #f1f1f1 !important;
  border-color: #444 !important;
}

/* Optional: lighten subtle hints or small text */
body.dark-mode small,
body.dark-mode .muted,
body.dark-mode .text-muted {
  color: #ccc !important;
}

/* Optional: fix checkbox label and button contrast */
body.dark-mode label,
body.dark-mode .form-check-label,
body.dark-mode .btn {
  color: #eee !important;
}

body.dark-mode .btn-light,
body.dark-mode .btn-outline-dark {
  background-color: #444 !important;
  border-color: #777 !important;
  color: #fff !important;
}

/* 🔧 Fix custom alert box in dark mode */
body.dark-mode .no-local-jobs {
  background-color: #2a2a2a !important;
  color: #f1f1f1 !important;
  border: 1px solid #555;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.4);
}

/* Adjust heading and paragraph text inside */
body.dark-mode .no-local-jobs h3,
body.dark-mode .no-local-jobs p,
body.dark-mode .no-local-jobs strong {
  color: #f1f1f1 !important;
}

/* Optional: Close (X) button icon styling in dark mode */
body.dark-mode .no-local-jobs .alert-close-btn svg {
  stroke: #ff6b81 !important;
}

body.dark-mode .no-local-jobs .alert-close-btn:hover svg {
  stroke: #fff !important;
}

.no-local-jobs {
  border-radius: 10px;
  padding: 20px;
  margin: 20px auto;
  max-width: 800px;
  position: relative;
  transition: background-color 0.3s ease, color 0.3s ease;
}


/* 🔧 Dark mode styling for the disclaimer popup */
body.dark-mode #disclaimerPopup {
  background-color: rgba(0, 0, 0, 0.6) !important; /* optional backdrop tint */
}

body.dark-mode #disclaimerPopup .popup-content {
  background-color: #2c2c2c !important;
  color: #f1f1f1 !important;
  border: 1px solid #444;
  box-shadow: 0 4px 16px rgba(0, 0, 0, 0.5);
}

/* Fix inline text elements */
body.dark-mode #disclaimerPopup h4,
body.dark-mode #disclaimerPopup p,
body.dark-mode #disclaimerPopup label,
body.dark-mode #disclaimerPopup small,
body.dark-mode #disclaimerPopup strong {
  color: #f1f1f1 !important;
}

/* Make horizontal rule subtle in dark mode */
body.dark-mode #disclaimerPopup hr {
  border-color: #555;
}

/* Button contrast improvements */
body.dark-mode #disclaimerPopup .btn-primary {
  background-color: #007bff !important;
  color: #fff !important;
}

body.dark-mode #disclaimerPopup .btn-success {
  background-color: #28a745 !important;
  color: #fff !important;
}

body.dark-mode #disclaimerPopup .btn-secondary {
  background-color: #444 !important;
  border-color: #666;
  color: #fff !important;
}

/* Optional: checkbox label tone */
body.dark-mode #disclaimerPopup input[type="checkbox"] + label {
  color: #ddd !important;
}

#disclaimerPopup .popup-content {
  border-radius: 10px;
  padding: 20px;
  max-width: 700px;
  margin: 40px auto;
  transition: all 0.3s ease-in-out;
}

.chart-title {
  text-align: center;
  font-size: 20px;
  margin-bottom: 12px;
}

.chart-subtotal {
  font-size: 16px;
  color: #666;
}

body.dark-mode .chart-subtotal {
  color: #ccc !important;
}

body.dark-mode canvas {
  background-color: transparent !important;
}

body.dark-mode .chartjs-render-monitor {
  color: #f1f1f1 !important;
}

/* Contact Form Button (same style as toggle theme) */
.contact-form-btn {
  background-color: #4CAF50; /* Green background */
  color: white;
  padding: 6px 16px;
  font-size: 16px;
  border-radius: 20px;
  text-decoration: none;
  cursor: pointer;
  border: none;
  display: inline-block;
  margin-left: 10px; /* Space between buttons */
}

.contact-form-btn:hover {
  background-color: #45a049; /* Darker green on hover */
}

/* Footer Button - Same as your original button styles */
.footer-btn, .close-btn {
  background: #0288d1; /* Blue background */
  color: #fff; /* White text */
  border: none;
  padding: 10px 18px;
  border-radius: 5px;
  cursor: pointer;
  font-size: 1em;
}

.footer-btn:hover {
  background-color: #0277bd; /* Darker blue on hover */
}



/*--------------------------------------------------------------------------12/06/2025*/

.company-name {
            font-size: 2em;
            color: #0288d1;
            font-weight: bold;
            margin-bottom: 0.3em;
            text-align: center;
        }
		
		#hideLoginBtn, #showLoginBtn {
    margin: 8px auto 12px auto;
    min-width: 120px;
    font-size: 1.1em;
    padding: 12px 28px;
    border-radius: 8px;
    border: none;
    background: #0288d1;
    color: #fff;
    box-shadow: 0 2px 12px #aaa;
    cursor: pointer;
    transition: background 0.15s;
	display: block;
}
#hideLoginBtn:hover, #showLoginBtn:hover {
    background: #026fa4;
}
@media (max-width: 600px) {
    #hideLoginBtn, #showLoginBtn {
        width: 98vw;
        padding: 12px 4vw;
        font-size: 1em;
    }
}
		

        .login-box {
            position: relative;
			padding-top: 2.2em;
			background: white;
            padding: 2em 3em;
            border-radius: 15px;
            box-shadow: 0 2px 24px #aaa;
            max-width: 340px;
            width: 100%;
            margin-bottom: 2em;
            display: flex;
            flex-direction: column;
            align-items: center;
			
        }
        .login-box form {
            width: 100%;
        }
        .login-box input[type="text"],
        .login-box input[type="password"],
        .login-box select {
            width: 100%;
            padding: 10px;
            margin-bottom: 1em;
            border: 1px solid #ccc;
            border-radius: 8px;
            font-size: 16px;
            box-sizing: border-box;
        }
        .login-box button {
            width: 100%;
            background: #0288d1;
            color: white;
            border: none;
            padding: 12px 0;
            border-radius: 8px;
            font-size: 16px;
            cursor: pointer;
        }
        .login-box button:hover {
            background: #026fa4;
        }
		
		
.login-close {
     position: absolute;
    top: 0.6em;       /* aligns with the top padding of .login-box */
    right: 1em;       /* aligns with the right padding of .login-box */
    font-size: 1em;
    background: none !important;
    border: none !important;
    color: #888 !important;
    cursor: pointer;
    z-index: 2;
    padding: 0 8px;
    line-height: 1.2;
    width: auto;
    height: auto;
    border-radius: 0 !important;
    box-shadow: none !important;
    display: flex;
    align-items: center;
    gap: 6px;
}


.login-close-caption {
    font-size: 1em;
    color: #555;
    margin-left: 2px;
    font-weight: 400;
    letter-spacing: 0.02em;
    user-select: none;
}

	@media (max-width: 450px) {
  .login-close-caption {
    display: none;
  }
}


@media (max-width: 600px) {
  .login-close-caption {
    display: none;
  }
}

@media (max-width: 500px) {
  .login-close-caption {
    display: none;
  }
}

		
.login-close:hover,
.login-close:focus {
    color: #d32f2f !important;
}
.login-close:hover .login-close-caption,
.login-close:focus .login-close-caption {
    color: #d32f2f;
}	
        .error {
            color: #b71c1c;
            background: #ffcdd2;
            padding: 0.5em 1em;
            border-radius: 6px;
            margin-bottom: 1em;
            text-align: center;
        }
        .about-box {
            background: #fff;
            padding: 1.3em 2em;
            border-radius: 16px;
            box-shadow: 0 1px 8px #e0e0e0;
            max-width: 900px;
            margin: 0.8em auto 1em auto;
            font-size: 16px;
            color: #222;
            text-align: justify;
            line-height: 1.7;
        }
        .about-box strong {
            color: #026fa4;
        }
        footer.about-box {
            margin-top: 0;
            margin-bottom: 2em;
        }
        @media (max-width: 500px) {
            .about-box {
                padding: 1em 0.7em;
                font-size: 15px;
            }
            .login-box {
                padding: 1em 0.7em;
                max-width: 97vw;
				position: relative;
				
            }
        }
		
		body {
			position: relative;
			overflow-x: hidden;
			}

		/* Faded, moving tech SVG background */
		.tech-bg {
			position: fixed;
			top: 0; left: 0;
			width: 100vw;
			height: 100vh;
			z-index: 0;
			background: transparent;
			pointer-events: none;
		}
		.tech-bg::before {
			content: '';
			position: absolute;
			width: 100vw;
			height: 100vh;
			opacity: 0.01; /* control fade */
			background: url('data:image/svg+xml;utf8,<svg width="1000" height="1000" xmlns="http://www.w3.org/2000/svg"><g stroke="%23028ad1" stroke-width="2" opacity="0.4"><line x1="0" y1="50" x2="1000" y2="50"/><line x1="0" y1="200" x2="1000" y2="200"/><line x1="0" y1="350" x2="1000" y2="350"/><line x1="0" y1="500" x2="1000" y2="500"/><line x1="0" y1="650" x2="1000" y2="650"/><line x1="0" y1="800" x2="1000" y2="800"/><circle cx="700" cy="150" r="24" fill="none"/><rect x="200" y="700" width="60" height="60" fill="none"/></g></svg>');
			background-size: cover;
			animation: bg-move 20s linear infinite;
		}

		@keyframes bg-move {
			0% { background-position: 0 0;}
			100% { background-position: 100px 100px;}
		}

		#matrix-bg {
			position: fixed;
			top: 0; left: 0;
			width: 100vw;
			height: 100vh;
			z-index: 0;
			opacity: 0.08; /* Adjust for more/less fade */
			pointer-events: none;
		}
		
		.content-container {
			position: relative;
			z-index: 1;
			width: 100%;
			display: flex;
			flex-direction: column;
			align-items: center;
		}

.preview-link {
    color: #1a0dab;
    text-decoration: underline;
    cursor: pointer;
    transition: color 0.2s;
}
.preview-link:hover {
    color: #d32f2f;
}

.preview-popup {
    display: none;
    position: absolute;
    z-index: 1000;
	background: #fff;
    border: 1px solid #ddd;
    box-shadow: 0 8px 32px rgba(0,0,0,0.18);
    padding: 1.3em 1.3em 1.3em 1.3em;
    max-width: 420px;
    border-radius: 16px;
    font-size: 1em;
    color: #222;
    overflow: auto;
    max-height: 350px;
    animation: fadeInPopup 0.32s cubic-bezier(0.36, 0.66, 0.04, 1) both;
    transition: box-shadow 0.2s;
}

@keyframes fadeInPopup {
    0% {
        opacity: 0;
        transform: translateY(20px) scale(0.97);
    }
    100% {
        opacity: 1;
        transform: translateY(0) scale(1);
    }
}

.preview-popup.hide {
    animation: fadeOutPopup 0.22s cubic-bezier(0.36, 0.66, 0.04, 1) both;
}

@keyframes fadeOutPopup {
    to {
        opacity: 0;
        transform: translateY(20px) scale(0.96);
    }
}

.preview-popup .popup-close {
    position: absolute;
    top: 7px;
    right: 9px;
    font-size: 1.3em;
    background: none;
    border: none;
    color: #888;
    cursor: pointer;
    transition: color 0.2s;
    z-index: 2;
    padding: 0;
}
.preview-popup .popup-close:hover {
    color: #d32f2f;
}

.preview-popup a {
    color: #0074cc;
    text-decoration: underline;
}

.client-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 0.8em 1.2em;
    margin-top: 0.7em;
}
.client-card {
    display: flex;
    align-items: center;
    gap: 0.6em;
    padding: 0.3em 0;
    font-size: 1em;
}
.client-icon {
    font-size: 1.3em;
}

@media (max-width: 600px) {
    .preview-popup {
        left: 50% !important;
        top: 50% !important;
        transform: translate(-50%, -50%) !important;
        width: 94vw !important;
        max-width: 96vw !important;
        min-width: 88vw !important;
        max-height: 70vh !important;
        min-height: 30vh !important;
        font-size: 1.13em !important;
        padding: 1.5em 1.1em 1.1em 1.1em !important;
        box-sizing: border-box !important;
    }
    .donor-tooltip {
        left: 50% !important;
        top: 50% !important;
        transform: translate(-50%, -50%) !important;
        width: 92vw !important;
        max-width: 97vw !important;
        min-width: 82vw !important;
        max-height: 60vh !important;
        min-height: 22vh !important;
        font-size: 1.13em !important;
        padding: 1.4em 1.1em 1.1em 1.1em !important;
        box-sizing: border-box !important;
        overflow-y: auto !important;
    }
    .donor-tooltip .donor-tooltip-close {
        top: 10px !important;
        right: 14px !important;
        font-size: 1.6em !important;
    }
    .client-grid {
        grid-template-columns: 1fr;
    }
}


/* Custom Scrollbar for preview-popup */
.preview-popup::-webkit-scrollbar {
    width: 10px;
}
.preview-popup::-webkit-scrollbar-thumb {
    background: #e1e1e1;
    border-radius: 8px;
}
.preview-popup::-webkit-scrollbar-track {
    background: #f6f6f6;
    border-radius: 8px;
}
.preview-popup:hover::-webkit-scrollbar-thumb {
    background: #bbb;
}

.donor-tooltip {
    display: none;
    position: absolute;
    background: #f9fafb;
    border: 1px solid #d2d6dc;
    box-shadow: 0 2px 14px rgba(0,0,0,0.11);
    padding: 0.9em 1.2em;
    border-radius: 10px;
    font-size: 0.98em;
    color: #232323;
    z-index: 2000;
    max-width: 280px;
    transition: opacity 0.17s;
    pointer-events: none;
}
.donor-tooltip strong {
    color: #1252c4;
    font-size: 1.04em;
}
.donor-tooltip a {
    color: #0080ff;
    text-decoration: underline;
    font-weight: 600;
    font-size: 0.97em;
}

.donor-modal {
    display: none;
    position: fixed;
    z-index: 2500;
    left: 0;
    top: 0;
    width: 100vw;
    height: 100vh;
    background: rgba(20,22,33,0.49);
    align-items: center;
    justify-content: center;
    animation: fadeInModal 0.21s;
}
@keyframes fadeInModal {
    from { opacity: 0;}
    to   { opacity: 1;}
}
.donor-modal-content {
    background: #fff;
    padding: 1em 1em 0.5em 1em;
    border-radius: 14px;
    max-width: 800px;
    width: 97vw;
    max-height: 86vh;
    box-shadow: 0 8px 32px rgba(0,0,0,0.22);
    position: relative;
    display: flex;
    flex-direction: column;
    animation: popupModalUp 0.33s;
}
@keyframes popupModalUp {
    from { transform: translateY(60px) scale(0.96);}
    to   { transform: translateY(0) scale(1);}
}
.donor-modal-header {
    font-size: 1.17em;
    font-weight: bold;
    margin-bottom: 0.4em;
    color: #225dc2;
}
.donor-modal-close {
    position: absolute;
    top: 10px;
    right: 16px;
    font-size: 2em;
    background: none;
    border: none;
    color: #888;
    cursor: pointer;
    z-index: 2;
    transition: color 0.18s;
}
.donor-modal-close:hover {
    color: #d32f2f;
}
.donor-modal-iframe {
    width: 100%;
    height: 65vh;
    border: none;
    background: #fcfcfc;
    border-radius: 8px;
    margin-bottom: 0.6em;
}


.donor-tooltip {
    display: none;
    position: absolute;
    background: #f9fafb;
    border: 1px solid #d2d6dc;
    box-shadow: 0 2px 14px rgba(0,0,0,0.11);
    padding: 0.9em 1.2em 1em 1.2em;
    border-radius: 10px;
    font-size: 0.98em;
    color: #232323;
    z-index: 2000;
    max-width: 280px;
    transition: opacity 0.17s;
    pointer-events: auto;
}

.donor-tooltip strong {
    color: #1252c4;
    font-size: 1.04em;
}

.donor-tooltip a {
    color: #0080ff;
    text-decoration: underline;
    font-weight: 600;
    font-size: 0.97em;
}

/* Tooltip Close Icon */
.donor-tooltip-close {
    position: absolute;
    top: 6px;
    right: 10px;
    font-size: 1.23em;
    color: #888;
    background: none;
    border: none;
    cursor: pointer;
    transition: color 0.19s;
    z-index: 2;
}
.donor-tooltip-close:hover {
    color: #d32f2f;
}

.modal-fallback {
    padding: 1.5em 1em 2em 1em;
    text-align: center;
}
.modal-fallback a.visit-in-new-tab {
    display: inline-block;
    margin-top: 0.9em;
    padding: 0.5em 1.3em;
    border-radius: 5px;
    background: #1752c4;
    color: #fff;
    text-decoration: none;
    font-weight: 600;
    transition: background 0.18s;
}
.modal-fallback a.visit-in-new-tab:hover {
    background: #d32f2f;
}

.modal-fallback {
    padding: 1.5em 1em 2em 1em;
    text-align: center;
}
.modal-fallback a.visit-in-new-tab {
    display: inline-block;
    margin-top: 0.9em;
    padding: 0.5em 1.3em;
    border-radius: 5px;
    background: #1752c4;
    color: #fff;
    text-decoration: none;
    font-weight: 600;
    transition: background 0.18s;
}
.modal-fallback a.visit-in-new-tab:hover {
    background: #d32f2f;
}

.footer-btn, .close-btn {
  background: #0288d1;
  color: #fff;
  border: none;
  padding: 10px 18px;
  border-radius: 5px;
  cursor: pointer;
  font-size: 1em;
}
.email-form-box {
  background: #fff;
  border-radius: 8px;
  padding: 24px 16px 16px 16px;
  box-shadow: 0 0 24px #0002;
  min-width: 320px;
  position: relative;
}
.close-btn {
  position: absolute;
  right: 12px;
  top: 12px;
  font-size: 1.5em;
  background: none;
  color: #333;
  border: none;
}



#email-form-container {
  display: none;
  opacity: 0;
  pointer-events: none;
  position: fixed;
  top: 0; left: 0;
  width: 100vw; height: 100vh;
  background: rgba(0,0,0,0.3);
  z-index: 999;
  transition: opacity 0.3s;
}
#email-form-container.active {
  display: block;
  opacity: 1;
  pointer-events: auto;
}
.email-form-box {
  background: #fff;
  border-radius: 8px;
  padding: 24px 16px 16px 16px;
  box-shadow: 0 0 24px #0002;
  min-width: 320px;
  max-width: 95vw;
  width: 100%;
  max-width: 400px;
  position: absolute;
  left: 50%; top: 50%;
  transform: translate(-50%, -50%);
}
.close-btn {
  position: absolute;
  right: 12px;
  top: 12px;
  font-size: 1.5em;
  background: none;
  color: #333;
  border: none;
  cursor: pointer;
}
#email-form-container input,
#email-form-container textarea,
#email-form-container select {
  width: 94%;
  margin: 8px 0;
  padding: 8px;
  border-radius: 4px;
  border: 1px solid #ddd;
}
#emailMsg {
  color: #008800;
  min-height: 20px;
}
@media (max-width:480px){
  .email-form-box { min-width:unset; width:96vw; }
}


@keyframes splashPop {
  0% { opacity: 0; transform: scale(0.5) translate(-50%,-50%);}
  40% { opacity: 1; transform: scale(1.12) translate(-50%,-50%);}
  60% { opacity: 1; transform: scale(1.04) translate(-50%,-50%);}
  100% { opacity: 0; transform: scale(0.7) translate(-50%,-50%);}
}
#splashThankYou.show {
  display: block !important;
  animation: splashPop 4s cubic-bezier(.2,1,.3,1) forwards;
}

@keyframes balloonUp {
  0% { opacity: 0; transform: translate(-50%, 50%);}
  10% { opacity: 1; }
  100% { opacity: 0; transform: translate(-50%, -150%);}
}
#successBalloon {
  transition: opacity 0.3s;
}
#successBalloon.show {
  display: block;
  animation: balloonUp 4s cubic-bezier(0.45,0,0.55,1) forwards;
}

#chat-widget {
  position: fixed;
  bottom: 24px;
  right: 24px;
  z-index: 9999;
}

.chat-fab {
  background: #1c85e8;
  color: #fff;
  border: none;
  border-radius: 50%;
  width: 56px; height: 56px;
  font-size: 2em;
  box-shadow: 0 4px 16px #0003;
  cursor: pointer;
}

.chat-modal {
  display: none;
  flex-direction: column;
  position: fixed;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
  width: 340px;
  max-width: 95vw;
  background: #fff;
  border-radius: 12px;
  box-shadow: 0 2px 24px #0002;
  overflow: hidden;
  z-index: 10000;
  animation: fadeIn 0.3s;
}

.chat-header {
  background: #1c85e8;
  color: #fff;
  padding: 12px;
  display: flex;
  justify-content: space-between;
  align-items: center;
}

.chat-body {
  max-height: 240px;
  overflow-y: auto;
  padding: 12px;
  background: #f9f9f9;
  font-size: 1em;
}

#chatForm {
  display: flex;
  border-top: 1px solid #eee;
}

#chatInput {
  flex: 1;
  padding: 10px;
  border: none;
  outline: none;
  font-size: 1em;
  border-radius: 0 0 0 12px;
}

#chatForm button {
  background: #1c85e8;
  color: #fff;
  border: none;
  padding: 10px 16px;
  border-radius: 0 0 12px 0;
  cursor: pointer;
}

.bot-message {
  color: #15803d;
  margin-bottom: 8px;
}

.user-message {
  color: #222;
  text-align: right;
  margin-bottom: 8px;
}

@keyframes fadeIn {
  0% {opacity:0; transform: translateY(30px);}
  100% {opacity:1; transform: translateY(0);}
}

@media (max-width: 420px) {
  #floatingChat {
    width: 98vw !important;
    min-width: 0 !important;
    left: 50% !important;
    top: 50% !important;
    transform: translate(-50%, -50%) !important;
    padding: 0 !important;
  }
}

<!-- latest -->
.fade-blur {
    opacity: 0.26 !important;
    filter: blur(3px);
    transition: opacity 0.5s, filter 0.5s;
    pointer-events: none;
    user-select: none;
}


.portfolio-modal {
  display: none;
  position: fixed;
  z-index: 9999;
  left: 0; top: 0; width: 100vw; height: 100vh;
  background: rgba(28,44,78,0.32);
  align-items: center; justify-content: center;
}
.portfolio-modal-content {
  background: #fff;
  border-radius: 18px;
  max-width: 760px;
  width: 96vw;
  max-height: 86vh;
  overflow-y: auto;
  box-shadow: 0 6px 32px #0288d155;
  padding: 28px 24px 24px 24px;
  position: relative;
  animation: popupModalUp 0.35s;
}
@keyframes popupModalUp {
  from { transform: translateY(70px) scale(0.96);}
  to   { transform: translateY(0) scale(1);}
}
.portfolio-modal-close {
  position: absolute; top: 20px; right: 24px;
  font-size: 2em; color: #bbb;
  cursor: pointer; background: none; border: none;
  transition: color 0.18s;
}
.portfolio-modal-close:hover { color: #0288d1; }

.expired-box {
  margin-top: 6px;
  display: flex;
  flex-wrap: wrap;
  gap: 6px;
  align-items: center;
}

.grace-message {
  background: #fff4e5;
  color: #92400e;
  padding: 6px 10px;
  border-radius: 5px;
  font-size: 0.85em;
}

.expired-tag {
  background: #eee;
  color: #555;
  padding: 6px 10px;
  border-radius: 5px;
  font-size: 0.85em;
}

.closing-soon-animated {
  background: #fdecea;
  color: #b91c1c;
  padding: 6px 10px;
  border-radius: 5px;
  font-weight: bold;
  font-size: 0.85em;
  animation: pulse 1.5s infinite;
}

@keyframes pulse {
  0% { box-shadow: 0 0 0 0 rgba(185, 28, 28, 0.4); }
  70% { box-shadow: 0 0 0 10px rgba(185, 28, 28, 0); }
  100% { box-shadow: 0 0 0 0 rgba(185, 28, 28, 0); }
}

/* 🌙 DARK MODE OVERRIDES */
body.dark-mode .grace-message {
  background: #3a3a3a;
  color: #facc15; /* warm yellow */
}

body.dark-mode .expired-tag {
  background: #2e2e2e;
  color: #ccc;
}

body.dark-mode .closing-soon-animated {
  background: #4b1c1c;
  color: #ffb4b4;
}

/* Optional: adjust Expires: label */
body.dark-mode .job-card p strong {
  color: #eee;
}

.job-card {
  position: relative;
  border-left: 6px solid #3b82f6; /* Tailwind blue-500 */
  border-radius: 12px;
  padding: 16px 18px;
  margin-bottom: 18px;
  background: #ffffff;
  box-shadow: 0 4px 10px rgba(0, 0, 0, 0.05);
  transition: all 0.3s ease;
}

/* 🌙 Dark mode adjustments */
body.dark-mode .job-card {
  background: #1f1f1f;
  border-left-color: #2563eb; /* Tailwind blue-600 */
  box-shadow: 0 4px 10px rgba(255, 255, 255, 0.05);
}

.job-card:hover {
  transform: translateY(-2px);
  box-shadow: 0 6px 16px rgba(0, 0, 0, 0.08);
}


    footer {
      text-align: center;
      padding: 20px;
      font-size: 14px;
      color: #888;
    }

   
   
  </style>
</head>
<body class="function-menu">
<!-- ✅ NAVIGATION -->
<div class="custom-navbar">
  <div class="nav-left">
    <a href="#" onclick="scrollToTop(); return false;">
      <img src="images/logo.png" alt="Logo" class="logo">
    </a>
  </div>
 <div class="nav-center">
  <a href="javascript:void(0)" onclick="openModal('register.php?page=register_jobseeker')">Jobseeker Register</a>
  <a href="javascript:void(0)" onclick="openModal('register.php?page=register_employer')">Employer Register</a>
  <button class="dashboard-toggle-btn top" onclick="toggleDashboardCards()" id="dashToggleBtnTop">
    Hide Dashboard
  </button>
</div>
<div class="nav-right" style="position: relative; margin-right: 20px; display: flex; align-items: center; gap: 10px;">
  
  <!-- 🌗 Theme Toggle Button -->
  <div id="themeToggleWrapper">
    <button id="themeToggleBtn">🌓 Toggle Theme</button>
  </div>
  <!-- 👤 User Login / Dropdown -->
  <div class="dropdown">
    <?php if (!isLogged()) { ?>
      <!-- Guest: Show Login button only -->
      <button type="button" class="btn btn-outline-light" onclick="openModal('login.php');" style="border-radius: 20px; padding: 6px 16px;" id="loginform_login">
        🔐 Login
      </button>
    <?php } else { ?>
      <!-- Logged-in user: Show dropdown menu -->
      <button type="button" class="btn btn-outline-light dropdown-toggle" onclick="toggleUserMenu()" style="border-radius: 20px; padding: 6px 16px;">
        👤 <?= $_SESSION["UserID"] ?> ▼
      </button>
      <div id="userMenuDropdown" class="dropdown-menu-custom">
        <a href="userinfo.php" class="dropdown-link">👤 User Profile</a>
        <a href="changepwd.php" class="dropdown-link">🔐 Change Password</a>
        <a href="login.php?a=logout" onclick="return confirm('Are you sure you want to log out?');" class="dropdown-link logout" id="logout_link">🚪 Log Out</a>
      </div>
    <?php } ?>
  </div>

</div>

</div>

<!-- ✅ HEADER SECTION -->
<header>
<h1>Welcome, {$username}</h1>
  <p>Jobseeker Dashboard</p>
</header>
 
<!-- ✅ DASHBOARD AREA -->
<br>
<div class="dashboard-filters" id="dashboardFilters"style="text-align:center;">
  <button id="filterAll" class="filter-btn blue">📊 All Data</button>
  <button id="filterMonth" class="filter-btn green">🗓 This Month</button>
  <button id="filter12mo" class="filter-btn purple">📅 Last 12 Months</button>
  <button id="downloadBtn">⬇️ Download</button>
</div>
<div class="chart-container-user-posted dashboard-chart-wrapper" id="dashboardCharts">
  <h3 style="text-align:center;">
    User-Posted Jobs by Location – {$filter_label}
    <span style="font-size: 16px; color: #666;">(Total: {$chart_total})</span>
  </h3>
  <canvas id="productChart" width="900" height="220"></canvas>
</div>

<div class="dashboard" id="dashboard">
<!-- GOVT -->
  <!-- Flip Card Template -->
  <div class="flip-card draggable" id="card_govt">
    <div class="flip-card-inner" id="govt_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟩</span>
            <strong>Government Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_govt', 'govt_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="govtChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="govt_active_pct"></span> {$govt_active}</div>
          <div><span class="dot expired"></span> <span id="govt_expired_pct"></span> {$govt_expired7}</div>
          <div><span class="dot archived"></span> <span id="govt_archived_pct"></span> {$govt_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟩</span>
            <strong>Government Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_govt', 'govt_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
These jobs are posted by government ministries or agencies. Most roles have fixed expiry dates and are managed via official HR systems.
</div>

        </div>
      </div>
    </div>
  

 
  <!-- sprep -->
  <div class="flip-card draggable" id="card_sprep">
    <div class="flip-card-inner" id="sprep_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟧</span>
            <strong>SPREP Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_sprep', 'sprep_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="sprepChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="sprep_active_pct"></span> {$sprep_active}</div>
          <div><span class="dot expired"></span> <span id="sprep_expired_pct"></span> {$sprep_expired7}</div>
          <div><span class="dot archived"></span> <span id="sprep_archived_pct"></span> {$sprep_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟧</span>
            <strong>SPREP Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_sprep', 'sprep_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Jobs posted by the Secretariat of the Pacific Regional Environment Programme. Often focused on climate, conservation, and sustainability.
</div>

      </div>
    </div>
  </div>
 
    <!-- spc -->
  <div class="flip-card draggable" id="card_spc">
    <div class="flip-card-inner" id="spc_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟪</span>
            <strong>SPC Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_spc', 'spc_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="spcChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="spc_active_pct"></span> {$spc_active}</div>
          <div><span class="dot expired"></span> <span id="spc_expired_pct"></span> {$spc_expired7}</div>
          <div><span class="dot archived"></span> <span id="spc_archived_pct"></span> {$spc_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟪</span>
            <strong>SPC Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_spc', 'spc_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Positions offered by the Pacific Community (SPC), covering health, education, agriculture, and regional development sectors.
</div>

      </div>
    </div>
  </div>
 
    <!-- undp -->
  <div class="flip-card draggable" id="card_undp">
    <div class="flip-card-inner" id="undp_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟥</span>
            <strong>UNDP Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_undp', 'undp_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="undpChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="undp_active_pct"></span> {$undp_active}</div>
          <div><span class="dot expired"></span> <span id="undp_expired_pct"></span> {$undp_expired7}</div>
          <div><span class="dot archived"></span> <span id="undp_archived_pct"></span> {$undp_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟥</span>
            <strong>UNDP Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_undp', 'undp_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Vacancies from the United Nations Development Programme. These often involve policy, climate resilience, or technical advisory roles.
</div>

      </div>
    </div>
  </div>
 
    <!-- pifs -->
  <div class="flip-card draggable" id="card_pifs">
    <div class="flip-card-inner" id="pifs_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟨</span>
            <strong>PIFS Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_pifs', 'pifs_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="pifsChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="pifs_active_pct"></span> {$pifs_active}</div>
          <div><span class="dot expired"></span> <span id="pifs_expired_pct"></span> {$pifs_expired7}</div>
          <div><span class="dot archived"></span> <span id="pifs_archived_pct"></span> {$pifs_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟨</span>
            <strong>PIFS Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_pifs', 'pifs_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Jobs listed by the Pacific Islands Forum Secretariat. Focused on regional cooperation, diplomacy, and policy development.
</div>

      </div>
    </div>
  </div>
 
   <!-- ffa -->
  <div class="flip-card draggable" id="card_ffa">
    <div class="flip-card-inner" id="ffa_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🪟</span>
            <strong>FFA Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_ffa', 'ffa_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="ffaChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="ffa_active_pct"></span> {$ffa_active}</div>
          <div><span class="dot expired"></span> <span id="ffa_expired_pct"></span> {$ffa_expired7}</div>
          <div><span class="dot archived"></span> <span id="ffa_archived_pct"></span> {$ffa_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🪟</span>
            <strong>FFA Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_ffa', 'ffa_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Roles from the Pacific Islands Forum Fisheries Agency, often technical and regional in nature, especially fisheries compliance and policy.
</div>

      </div>
    </div>
  </div>
 
    <!-- pjn -->
  <div class="flip-card draggable" id="card_pjn">
    <div class="flip-card-inner" id="pjn_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">📂</span>
            <strong>Pacific Vacancies Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_pjn', 'pjn_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="pjnChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="pjn_active_pct"></span> {$pjn_active}</div>
          <div><span class="dot expired"></span> <span id="pjn_expired_pct"></span> {$pjn_expired7}</div>
          <div><span class="dot archived"></span> <span id="pjn_archived_pct"></span> {$pjn_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">📂</span>
            <strong>Pacific Vacancies Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_pjn', 'pjn_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Curated job opportunities from multiple Pacific organizations and private sectors, collected to support regional talent access.
</div>

      </div>
    </div>
  </div>
 
    <!-- user -->
  <!-- Flip Card Template -->
  <div class="flip-card draggable" id="card_user">
    <div class="flip-card-inner" id="user_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟦</span>
            <strong>User-Posted Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_user', 'user_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="userChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="user_active_pct"></span> {$user_active}</div>
          <div><span class="dot expired"></span> <span id="user_expired_pct"></span> {$user_expired7}</div>
          <div><span class="dot archived"></span> <span id="user_archived_pct"></span> {$user_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Description -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟦</span>
            <strong>User-Posted Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_user', 'user_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Jobs manually submitted by employers or recruiters on this platform. These listings follow platform expiry, extension, and archive rules.
</div>

      </div>
    </div>
  </div>
</div>



<!-- 📢 Job Feed Disclaimer & Guest Prompt -->
<div id="disclaimerPopup" class="disclaimer-popup-centered">
  <div class="popup-content">
    <h4 style="margin-bottom: 4px;">📢 Job Sources & Feed <i class="fas fa-info-circle"></i> Disclaimer</h4>
    <small style="font-size: 12px; color: #666;">Transparency notice for all listed opportunities</small>

    <p>This live feed highlights job opportunities from the career pages of regional organizations like SPREP, SPC, PIFS, FFA, and UNDP, government listings from the Samoa Public Service Commission (PSC), and postings from government-owned corporations. It also includes remote global live-feed API job listings from platforms like the Himalayas.</p>

    <p>These listings help jobseekers discover local, regional, and international employment opportunities. Please note that all application procedures, rights, and recruitment decisions are the sole responsibility of the respective hiring organizations or agencies.</p>

    <hr style="margin: 10px 0;">

    <p style="font-weight: bold; font-size: 14px;">👋 Welcome, Guest!</p>
    <p 🧑‍💼 style="font-size: 13px;">To apply for jobs posted by <strong>Private Sector Employers</strong> or receive alerts for <strong>Public Sector</strong> opportunities listed on this platform, please register below:</p>

    <div class="guest-popup-buttons" style="display: flex; gap: 10px; margin-bottom: 12px;">
      <button onclick="openModal('register.php?page=register_jobseeker')" class="btn btn-sm btn-primary">Jobseeker Register</button>
      <button onclick="openModal('register.php?page=register_employer')" class="btn btn-sm btn-success">Employer Register</button>
    </div>
   
    <div style="margin-top: 10px; display: flex; align-items: center; gap: 8px;">
    <input type="checkbox" id="dontShowAgain" style="transform: scale(1.2);" />
    <label for="dontShowAgain" style="font-size: 13px;">Don’t show this again for 7 days</label>
    </div>
   
    <button class="btn btn-sm btn-secondary" onclick="toggleDisclaimerPopup()">Close</button>
  </div>
</div>


<!-- 🌐 Collapsible Floating Panel -->
<div id="floatingPanel" class="floating-panel collapsed">
  <button class="panel-toggle" onclick="togglePanel()">☰</button>

 <div class="panel-buttons">
    <button onclick="toggleDisclaimerPopup()">Disclaimer ℹ️</button>
    </div>
</div>

<!-- Custom Jobs Grid -->
<div class="custom-jobs-grid" id="jobsContainer">
  <?php echo $job_cards; ?>  <!-- Render dynamic job cards -->
</div>

<!-- Custom External Jobs Grid -->
<div class="custom-external-jobs-wrapper">
  <?php echo $external_jobs; ?>  <!-- Render dynamic external job listings -->
</div>


<!-- ✅ Job Cards -->
<div class="jobs-grid" id="jobsContainer">
  {$job_cards}
</div>
<!-- ✅ EXTERNAL SOURCES IF ANY -->
<div class="external-jobs-wrapper">
  {$external_jobs}
</div>
<!-- ✅ MODALS (Standard + Remote Jobs) -->
<div id="customModal">
  <div class="modal-content">
    <button class="modal-close" onclick="closeModal()">✖</button>
    <iframe id="modalFrame" src="" width="100%" height="100%" style="border:none;"></iframe>
  </div>
</div>
<div id="remoteJobModal">
  <div class="modal-content">
    <button class="modal-close" onclick="closeRemoteJobModal()">×</button>
    <iframe id="remoteJobFrame" src="" allowfullscreen></iframe>
  </div>
</div>

<!-- 🧩 Footer -->
<footer style="text-align: center;">Copyright
  &copy; <?= date('Y') ?>
  <a href="https://mcil.gov.ws/" target="_blank" title="Visit MCIL website">Ministry of Commerce, Industry and Labour</a>
  |
  Developed by
  <a href="https://bitsolution.ws/" target="_blank" title="Visit developer's website">Bitsolution</a>
</footer>

<script>
// 🔽 This function toggles the dropdown menu when you click the user button
function toggleDropdown() {
  document.getElementById("profileDropdown").classList.toggle("show");
}

// 🖱️ This global click handler closes the dropdown when clicking outside of it
window.onclick = function(event) {
  // If the clicked element is NOT inside a dropdown...
  if (!event.target.closest('.dropdown')) {
    // Hide all elements with the class 'dropdown-content'
    document.querySelectorAll(".dropdown-content").forEach(drop => {
      drop.classList.remove("show");
    });
  }
}
</script>





<!-- Chart.js -->
<!-- Load Chart.js and the Data Labels plugin -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels"></script>

<script>
// 📊 Chart instance reference and default type
let chartInstance = null;
let currentType = 'bar';

// 📁 Chart data passed from PHP (PHPRunner variables)
const allData = {
  labels: {$chart_labels},              // X-axis labels
  values: {$chart_values},              // Y-axis values
  year: "<?php echo $selected_year ?>"  // Selected year
};

// 🔧 Main function to draw the chart
function drawChart(type = 'bar') {
  const ctx = document.getElementById('productChart').getContext('2d');

  // If a chart already exists, destroy it before redrawing
  if (chartInstance) chartInstance.destroy();

  // Create new chart
chartInstance = new Chart(ctx, {
    type: type,
    data: {
      labels: allData.labels,
      datasets: [{
        label: '',
        data: allData.values,
        backgroundColor: [
          '#007BFF', '#28A745', '#DC3545', '#FFC107', '#6F42C1', '#17A2B8'
        ],
        borderRadius: 6
      }]
    },
    options: {
      responsive: true,
      plugins: {
        // 🎯 Show labels directly on top of bars (if bar chart)
        datalabels: {
          display: type === 'bar',
          anchor: 'end',
          align: 'top',
          font: {
            weight: 'bold'
          }
        },
        legend: {
          display: type !== 'bar' // Only show legend for non-bar charts
        },
        title: {
          display: false // Title is hidden (you can enable it if you want)
        }
      },
      animation: {
        duration: 1000,
        easing: 'easeOutBounce'
      },
      scales: type === 'bar' ? {
        y: {
          beginAtZero: true
        }
      } : {} // No Y-axis if not bar
    },
    plugins: [ChartDataLabels]
  });
}


// 🔄 Toggle between bar and pie chart views
function toggleChartType() {
  currentType = currentType === 'bar' ? 'pie' : 'bar';
  drawChart(currentType);
}

// ⬇️ Export the chart as a PNG image
function downloadChart() {
  const link = document.createElement('a');
  link.download = 'product_chart.png';
  link.href = chartInstance.toBase64Image(); // Convert chart to image
  link.click();
}

// 📅 Apply year-based filter to reload the page with a query string
function filterByYear(year) {
  if (year === "all") {
    window.location.href = window.location.pathname;
  } else {
    const params = new URLSearchParams(window.location.search);
    params.set('year', year);
    window.location.search = params.toString();
  }
}

// 🧠 Draw chart after page is fully loaded
document.addEventListener("DOMContentLoaded", () => {
  drawChart();
});
</script>


<script>
// 🪟 Function to open a modal and load a URL in the iframe
function openModal(url) {
  event.preventDefault(); // Prevent the default link or button behavior

  const modal = document.getElementById("customModal");     // Modal container
  const frame = document.getElementById("modalFrame");      // The iframe inside the modal

  frame.src = url;                // Set the iframe's source to the provided URL
  modal.style.display = "flex";  // Show the modal (flex to center it)
  document.body.style.overflow = 'hidden'; // Prevent page scroll while modal is open
}

// ❌ Function to close the modal
function closeModal() {
  const modal = document.getElementById("customModal");
  const frame = document.getElementById("modalFrame");

  modal.style.display = "none";  // Hide the modal
  frame.src = "";                // Clear the iframe content
  document.body.style.overflow = ''; // Re-enable scrolling on the page
}
</script>



<script>
// 📌 Store the previous scroll position
let lastScrollY = window.scrollY;

// 🎯 Target the page header element
const header = document.querySelector("header");

// 🚀 Listen for scroll events
window.addEventListener("scroll", () => {
  const currentScrollY = window.scrollY;

  // 📦 Add 'shadow' and 'shrink' classes when scrolled more than 80px
  if (currentScrollY > 80) {
    header.classList.add("shadow", "shrink");
  } else {
    header.classList.remove("shadow", "shrink");
  }

  // 👻 Hide header if scrolling down fast past 150px
  if (currentScrollY > lastScrollY && currentScrollY > 150) {
    header.classList.add("hidden");
  } else {
    header.classList.remove("hidden");
  }

  // 🔁 Update scroll position
  lastScrollY = currentScrollY;
});
</script>


<script>
// 🔍 Main function to filter jobs based on keyword, category, and state
function filterJobs(keyword) {
  keyword = keyword.toLowerCase(); // Convert keyword to lowercase for case-insensitive matching

  const selectedState = document.getElementById("filterState").value.toLowerCase();   // Selected State
  const catFilter = document.getElementById("filterCategory").value.toLowerCase();    // Selected Category

  // Loop through each job card
  document.querySelectorAll('.card').forEach(card => {
    const title = card.querySelector('.job-title').textContent.toLowerCase();         // Job Title
    const category = card.getAttribute('data-category')?.toLowerCase() || "";         // Job Category (from data-attribute)
    const state = card.getAttribute('data-state')?.toLowerCase() || "";               // Job State (from data-attribute)

    const matchesCat = !catFilter || category.includes(catFilter);     // Match if no filter or category matches
    const matchesState = !selectedState || state.includes(selectedState); // Same logic for state
    const matchesTitle = title.includes(keyword);                     // Title match

    // 👁 Show or hide the card based on matching logic
    card.style.display = (matchesTitle && matchesCat && matchesState) ? 'block' : 'none';
  });
}

// 🧭 These trigger the main filterJobs() when dropdown filters change
function filterByCategory(category) {
  const keyword = document.querySelector('input[type=text]').value;
  filterJobs(keyword);
}

function filterJobsByState(state) {
  const keyword = document.querySelector('input[type=text]').value;
  filterJobs(keyword);
}

// ⬇️ Export filtered jobs to CSV file
function exportCSV() {
  let csv = "Title,Company,City,Posted,Expires\n"; // CSV Header

  // Loop through visible job cards and extract text
  document.querySelectorAll('.card').forEach(card => {
    const title = card.querySelector('.job-title').textContent.trim(); // Job title

    const meta = card.querySelectorAll('.job-meta')[0].innerText.split('\n'); // Meta lines (assumes 4 lines)
    csv += `${title},${meta[0].split(': ')[1]},${meta[1].split(': ')[1]},${meta[2].split(': ')[1]},${meta[3].split(': ')[1]}\n`;
  });

  // Encode the CSV as a downloadable link
  const encodedUri = encodeURI('data:text/csv;charset=utf-8,' + csv);
  const link = document.createElement('a');
  link.setAttribute('href', encodedUri);
  link.setAttribute('download', 'jobs_list.csv');

  // Trigger download
  document.body.appendChild(link);
  link.click();
  document.body.removeChild(link);
}
</script>


<script>
// 🗺️ Filter jobs based on selected state, title input, and category filter
function filterByState(state) {
  state = state.toLowerCase(); // Ensure case-insensitive comparison

  const titleInput = document.querySelector('input[type=text]').value.toLowerCase();   // Keyword typed in
  const catFilter = document.getElementById("filterCategory").value.toLowerCase();     // Selected category

  // 🔁 Loop through all job cards
  document.querySelectorAll('.card').forEach(card => {
    const description = card.innerText.toLowerCase();                                   // Entire card text
    const stateMatches = !state || description.includes(state);                         // True if no state filter or match
    const titleMatch = card.querySelector('.job-title').textContent.toLowerCase().includes(titleInput); // Title match
    const catMatch = !catFilter || card.getAttribute('data-category')?.toLowerCase().includes(catFilter); // Category match

    // 👁 Show or hide card based on combined matching rules
    card.style.display = (stateMatches && titleMatch && catMatch) ? 'block' : 'none';
  });
}
</script>


<script>
// 🪟 Open a popup modal and load a page into the iframe
function openPopup(url) {
  const modal = document.getElementById("customModal");   // The modal container
  const iframe = document.getElementById("modalFrame");   // The iframe inside the modal

  iframe.src = url;                // Load the requested page in the iframe
  modal.style.display = "flex";   // Show the modal using flexbox
  document.body.style.overflow = "hidden"; // Prevent background scrolling
}
</script>


<script>
// 📩 Listen for messages sent from an iframe (usually after a form submit)
window.addEventListener("message", function(event) {
  // ✅ If the message from the iframe is exactly 'application_success'
  if (event.data === "application_success") {
    // ❌ Close the modal (assumes you're using Bootstrap modal)
    $('#applyModal').modal('hide');

    // ✅ Show success toast notification
    const toast = new bootstrap.Toast(document.getElementById('applicationToast'));
    toast.show();
  }
});
</script>


<script>
// 🔁 Toggle between showing preview and full description in job cards
function toggleDescription(link) {
  // 🔍 Find the preview and full description elements
  const preview = link.previousElementSibling.previousElementSibling; // The short preview
  const full = link.previousElementSibling;                           // The full description

  // 🎭 Show or hide full/preview description
  if (full.style.display === "none") {
    preview.style.display = "none";      // Hide preview
    full.style.display = "inline";       // Show full text
    link.textContent = "Show less";      // Update link text
  } else {
    preview.style.display = "inline";    // Show preview again
    full.style.display = "none";         // Hide full description
    link.textContent = "Read more";      // Reset link text
  }
}
</script>


<script>
// 🔁 Toggle between preview and full location display
function toggleLocation(link) {
  const preview = link.previousElementSibling.previousElementSibling; // Short version
  const full = link.previousElementSibling;                           // Full location

  if (full.style.display === "none") {
    preview.style.display = "none";
    full.style.display = "inline";
    link.textContent = "Show less";
  } else {
    preview.style.display = "inline";
    full.style.display = "none";
    link.textContent = "Read more";
  }
}
</script>

<script>
// ❌ Close the guest welcome popup
function closeGuestPopup() {
  const popup = document.getElementById("guestPopup");
  popup.style.display = "none";
}
</script>

<script>
// 📢 Show a message prompting guests to register before applying
function showApplyMessage(btn, jobId) {
  // ✅ If the user is already logged in, do nothing
  if (<?php echo json_encode(isLogged()); ?>) return;

  // 🔍 Check if the popup already exists
  let existing = btn.parentElement.querySelector('.apply-message-popup');

  // 🧱 If not, create and insert it
  if (!existing) {
    const div = document.createElement('div');
    div.className = 'apply-message-popup';
    div.innerHTML = `
      You need to register to apply.<br>
      <button onclick="openModal('register.php?page=register_jobseeker')">Register</button>
    `;
    btn.parentElement.appendChild(div);
  }

  // 📣 Show the popup
  btn.parentElement.querySelector('.apply-message-popup').style.display = 'block';

  // ⏱ Hide it after 6 seconds
  setTimeout(() => {
    const popup = btn.parentElement.querySelector('.apply-message-popup');
    if (popup) {
      popup.style.display = 'none';
    }
  }, 6000);
}
</script>

<script>
// 🌐 Open remote job modal and load external job URL in iframe
function openRemoteJobModal(url) {
  document.getElementById('remoteJobFrame').src = url;         // Load the job URL
  document.getElementById('remoteJobModal').style.display = 'flex'; // Show modal
  document.body.style.overflow = 'hidden';                     // Disable background scroll
}

// ❌ Close the modal and clear iframe content
function closeRemoteJobModal() {
  document.getElementById('remoteJobModal').style.display = 'none'; // Hide modal
  document.getElementById('remoteJobFrame').src = '';               // Clear iframe
  document.body.style.overflow = '';                                // Restore scroll
}

// 🖱 Close modal if user clicks outside the iframe content area
window.addEventListener('click', function(e) {
  const modal = document.getElementById('remoteJobModal');

  // Only close if the actual background (not the iframe) was clicked
  if (e.target === modal) {
    closeRemoteJobModal();
  }
});
</script>

<script>
// 📂 Scroll to a category section when it's selected from the dropdown
document.getElementById("category").addEventListener("change", function() {
  const value = this.value; // Get the selected category value
  const el = document.getElementById("category-" + value); // Match corresponding section ID

  // 🧭 Scroll to the element smoothly if it exists
  if (el) {
    el.scrollIntoView({
      behavior: "smooth", // Smooth scroll effect
      block: "start"      // Align to top of the page
    });
  }
});
</script>

<script>
document.addEventListener("DOMContentLoaded", function () {
  const wrapper = document.querySelector(".external-jobs-wrapper"); // Container for remote jobs

  // 🔁 Function to fetch jobs from the server using AJAX
  function fetchRemoteJobs(page) {
    // ⏳ Show a loading animation while fetching
    wrapper.innerHTML = `
      <div class="loader">
        Loading<span class="dot">.</span><span class="dot">.</span><span class="dot">.</span>
      </div>
    `;

    // 📡 Fetch the remote job listings
    fetch(`jobsjobs_list.php?page=${page}&ajax_remote_jobs=1`)
      .then(res => res.text())           // Convert response to HTML string
      .then(html => {
        const tempDiv = document.createElement("div");
        tempDiv.innerHTML = html;
        tempDiv.style.opacity = 0;
        tempDiv.style.transition = "opacity 0.4s ease, transform 0.4s ease";
        tempDiv.style.transform = "translateX(30px)";

        // 🔄 Replace current job listings with new content
        wrapper.innerHTML = '';
        wrapper.appendChild(tempDiv);

        // ✨ Animate fade-in after short delay
        setTimeout(() => {
          tempDiv.style.opacity = 1;
          tempDiv.style.transform = "translateX(0)";
        }, 50);
      });
  }

//_________________________________________________________________________________________________New

function animateNewCards() {
  document.querySelectorAll('.job-card').forEach((card, index) => {
    setTimeout(() => {
      card.classList.add('highlight-card');
      setTimeout(() => {
        card.classList.remove('highlight-card');
      }, 900); // match animation duration
    }, index * 100); // slight stagger between cards
  });
}

//________________________________________________________________________________________________New

  // 🖱 Listen for clicks on pagination links
  document.body.addEventListener("click", function (e) {
    if (e.target.classList.contains("page-link")) {
      e.preventDefault();
      const page = e.target.dataset.page; // Get the page number from data-page attribute
      fetchRemoteJobs(page);             // Load jobs via AJAX
    }
  });
});
</script>

<script>
// 🪟 Open a modal and load content via URL in iframe
function openModalWithContent(url) {
  const iframe = document.getElementById("modalFrame");
  iframe.src = url; // Load external content
  document.getElementById("customModal").style.display = "flex"; // Show modal
  document.body.style.overflow = 'hidden'; // Prevent background scroll
}

// ❌ Close the modal and clear the iframe
function closeModal() {
  const iframe = document.getElementById("modalFrame");
  iframe.src = ""; // Clear iframe
  document.getElementById("customModal").style.display = "none"; // Hide modal
  document.body.style.overflow = ''; // Restore scrolling
}
</script>

<script>
// 🔍 On scroll, resize the logo for a sleek effect
window.addEventListener("scroll", function () {
  const logo = document.querySelector(".logo");     // Logo image element
  const header = document.querySelector("header");  // Main page header

  // 🎯 If user scrolls down more than 80px, shrink the logo
  if (window.scrollY > 80) {
    logo.style.transform = "scale(0.8)";
  } else {
    logo.style.transform = "scale(1)";
  }
});
</script>

<script>
// 🧠 Wait until the document is fully loaded
document.addEventListener("DOMContentLoaded", function () {
  const logo = document.querySelector(".logo");    // Your logo element
  const header = document.querySelector("header"); // The header you want to observe

  // 👁️ Create an IntersectionObserver to monitor header visibility
  const observer = new IntersectionObserver(
    ([entry]) => {
      if (entry.isIntersecting) {
        // ✅ Header is visible — restore full logo size
        logo.classList.remove("shrink");
      } else {
        // 🔽 Header is out of view — shrink the logo
        logo.classList.add("shrink");
      }
    },
    {
      threshold: 0.1 // Trigger the callback when 10% of the header is visible
    }
  );

  // 🚀 Start observing the header
  if (header) {
    observer.observe(header);
  }
});
</script>

<script>
function dismissNoJobs() {
  const alert = document.getElementById('noJobsAlert');
  alert.style.opacity = '0';
  alert.style.transform = 'translateY(-20px)';
  setTimeout(() => alert.style.display = 'none', 400);
}
</script>

<style>
/* Animation when card appears */
.slide-in {
  animation: slideFadeIn 0.8s ease-out;
}

@keyframes slideFadeIn {
  from {
    transform: translateY(30px);
    opacity: 0;
  }
  to {
    transform: translateY(0px);
    opacity: 1;
  }
}
</style>

<script>
// 🎯 Toggle popup and store dismiss state
function toggleDisclaimerPopup() {
  const popup = document.getElementById("disclaimerPopup");
  const trigger = document.getElementById("disclaimerTrigger");
  const dontShow = document.getElementById("dontShowAgain");
  const toast = document.getElementById("toastDisclaimer");

  const isHidden = popup.style.display === "none" || !popup.style.display;
  popup.style.display = isHidden ? "block" : "none";
  trigger.style.display = isHidden ? "none" : "block";

  if (!isHidden) {
    const dismissUntil = dontShow?.checked
      ? Date.now() + 7 * 24 * 60 * 60 * 1000 // 7 days
      : Date.now() + 1 * 60 * 60 * 1000;     // 1 hour

    localStorage.setItem("jobDisclaimerDismissedUntil", dismissUntil);

    // ✅ Show toast if checkbox was ticked
    if (dontShow?.checked && toast) {
      toast.style.display = "block";
      setTimeout(() => {
        toast.style.display = "none";
      }, 4000); // hide after 4 seconds
    }
  }
}

document.addEventListener("DOMContentLoaded", function () {
  const jobCards = document.getElementById("jobsContainer");
  const externalJobs = document.querySelector(".external-jobs-wrapper");
  const popup = document.getElementById("disclaimerPopup");
  const trigger = document.getElementById("disclaimerTrigger");

  const hasJobs = jobCards && jobCards.innerHTML.trim() !== "";
  const hasExternal = externalJobs && externalJobs.innerHTML.trim() !== "";

  const storedTime = localStorage.getItem("jobDisclaimerDismissedUntil");
  const now = Date.now();

  const isDismissed = storedTime && parseInt(storedTime) > now;

  if (!hasJobs && !hasExternal) {
    popup.style.display = "none";
    trigger.style.display = "none";
  } else {
    popup.style.display = isDismissed ? "none" : "block";
    trigger.style.display = isDismissed ? "block" : "none";
  }
});
</script>

<script>
function manualReopenDisclaimer() {
  const popup = document.getElementById("disclaimerPopup");
  const trigger = document.getElementById("disclaimerTrigger");
  if (popup && trigger) {
    popup.style.display = "block";
    trigger.style.display = "none";
  }
}

document.addEventListener("DOMContentLoaded", function () {
  const label = document.getElementById("disclaimerLastSeen");
  const timestamp = localStorage.getItem("jobDisclaimerDismissedUntil");

  if (label && timestamp) {
    const date = new Date(parseInt(timestamp));
    label.textContent = date.toLocaleString();
  } else if (label) {
    label.textContent = "Not dismissed yet.";
  }
});
</script>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels"></script>
<script>
const ctx = document.getElementById('productChart').getContext('2d');
// Assigned from PHPRunner
const labels = {$chart_labels};
const values = {$chart_values};

const total = values.reduce((sum, val) => sum + val, 0);

const chart = new Chart(ctx, {
  type: 'bar',
  data: {
    labels: labels,
    datasets: [{
      label: 'Jobs by Location',
      data: values,
      backgroundColor: [
        '#007BFF', '#28A745', '#DC3545', '#FFC107', '#6F42C1', '#17A2B8'
      ],
      borderRadius: 6
    }]
  },
  options: {
    responsive: true,
    plugins: {
      tooltip: {
        callbacks: {
          label: function(context) {
            const value = context.raw;
            const percentage = ((value / total) * 100).toFixed(1);
            const jobText = value === 1 ? "Job" : "Jobs";
            return `${value} ${jobText} in ${context.label}`;
            //return `${value} ${jobText} in ${context.label} (${percentage}%)`;
          }
        }
      },
      datalabels: {
        display: true,
        anchor: 'end',
        align: 'top',
        font: {
          weight: 'bold'
        }
      },
      legend: {
        display: false
      },
      title: {
        display: false
      }
    },
    animation: {
      duration: 1000,
      easing: 'easeOutBounce'
    },
    scales: {
      y: {
        beginAtZero: true
      }
    }
  },
  plugins: [ChartDataLabels]
});
</script>

<script>
function scrollToTop() {
  window.scrollTo({
    top: 0,
    behavior: 'smooth'
  });
  const header = document.querySelector("header");
  // 👇 Add a glow or bounce effect when header becomes visible
  header.classList.add("highlight-top");
  // Remove the class after animation ends (1 second)
  setTimeout(() => {
    header.classList.remove("highlight-top");
  }, 900);
}
</script>

<script>
function openContactModal() {
  document.getElementById("contactModal").style.display = "flex";
}
function closeContactModal() {
  document.getElementById("contactModal").style.display = "none";
}
function submitContact() {
  const email = document.getElementById("contactEmail").value;
  const message = document.getElementById("contactMessage").value;
  const feedback = document.getElementById("contactFeedback");

  // TODO: replace with real AJAX or send to PHP endpoint
  feedback.innerHTML = `✅ Thank you! We'll respond shortly.`;
  document.getElementById("contactEmail").value = "";
  document.getElementById("contactMessage").value = "";
  return false;
}

function openChat() {
  alert("🔧 Chat widget integration coming soon!");
}
</script>

<script>
function togglePanel() {
  const panel = document.getElementById("floatingPanel");
  panel.classList.toggle("expanded");

  const toggleBtn = panel.querySelector(".panel-toggle");
  toggleBtn.textContent = panel.classList.contains("expanded") ? "⏶" : "☰";
}
</script>

<!-- Load Chart.js and DataLabels plugin first -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels"></script>

<!-- 📊 SCRIPT: Initialize All Charts -->
<script>
document.addEventListener("DOMContentLoaded", function () {
  const charts = [
    { id: "govtChart", data: [{$govt_active_raw}, {$govt_expired7_raw}, {$govt_archived_raw}], prefix: 'govt' },
    { id: "sprepChart", data: [{$sprep_active_raw}, {$sprep_expired7_raw}, {$sprep_archived_raw}], prefix: 'sprep' },
    { id: "spcChart", data: [{$spc_active_raw}, {$spc_expired7_raw}, {$spc_archived_raw}], prefix: 'spc' },
    { id: "undpChart", data: [{$undp_active_raw}, {$undp_expired7_raw}, {$undp_archived_raw}], prefix: 'undp' },
    { id: "pifsChart", data: [{$pifs_active_raw}, {$pifs_expired7_raw}, {$pifs_archived_raw}], prefix: 'pifs' },
    { id: "ffaChart", data: [{$ffa_active_raw}, {$ffa_expired7_raw}, {$ffa_archived_raw}], prefix: 'ffa' },
    { id: "pjnChart", data: [{$pjn_active_raw}, {$pjn_expired7_raw}, {$pjn_archived_raw}], prefix: 'pjn' },
    { id: "userChart", data: [{$user_active_raw}, {$user_expired7_raw}, {$user_archived_raw}], prefix: 'user' },
    { id: "himalayasChart", data: [0, 0, 0] }
  ];

    charts.forEach(({ id, data, prefix }) => {
    const ctx = document.getElementById(id);
    if (!ctx) return;

    const total = data.reduce((a, b) => a + b, 0);
    const percentages = data.map(v => total > 0 ? ((v / total) * 100).toFixed(1) + '%' : '0%');

    if (prefix) {
      const activeEl = document.getElementById(`${prefix}_active_pct`);
      const expiredEl = document.getElementById(`${prefix}_expired_pct`);
      const archivedEl = document.getElementById(`${prefix}_archived_pct`);
      if (activeEl) activeEl.textContent = percentages[0];
      if (expiredEl) expiredEl.textContent = percentages[1];
      if (archivedEl) archivedEl.textContent = percentages[2];
    }

    new Chart(ctx, {
      type: 'doughnut',
      data: {
        labels: ["Active", "Expired", "Archived"],
        datasets: [{
          data: data,
          backgroundColor: ["#34a853", "#ea4335", "#9aa0a6"],
          borderWidth: 0
        }]
      },
      options: {
        plugins: {
          legend: { display: false },
          datalabels: {
            color: '#fff',
            font: { weight: 'bold', size: 12 },
            formatter: (value, ctx) => {
              const sum = ctx.chart.data.datasets[0].data.reduce((a, b) => a + b, 0);
              return sum ? Math.round((value / sum) * 100) + '%' : '';
            }
          }
        },
        cutout: "70%",
        responsive: true,
        maintainAspectRatio: false
      },
      plugins: [ChartDataLabels]
    });
  });
});
</script>

<!-- 📌 DRAG + PIN SCRIPT -->
<script>
function togglePin(button, cardId, innerId) {
  const card = document.getElementById(cardId);
  const inner = document.getElementById(innerId);
  const label = button.nextElementSibling;

  if (inner.classList.contains("pinned")) {
    inner.classList.remove("pinned");
    card.classList.remove("pinned");
    label.textContent = "Pin to stop flip";
    button.textContent = "";
  } else {
    inner.classList.add("pinned");
    card.classList.add("pinned");
    label.textContent = "Unpin to allow flip";
    button.textContent = "📌";
  }
}

function makeDraggable(selector) {
  const container = document.getElementById("dashboard");
  let dragged = null;

  document.querySelectorAll(selector).forEach(card => {
    card.setAttribute("draggable", true);

    card.addEventListener("dragstart", function (e) {
      dragged = this;
      e.dataTransfer.effectAllowed = "move";
      this.style.opacity = 0.5;
    });

    card.addEventListener("dragend", function () {
      this.style.opacity = 1;
    });

    card.addEventListener("dragover", function (e) {
      e.preventDefault();
      e.dataTransfer.dropEffect = "move";
    });

    card.addEventListener("drop", function (e) {
      e.preventDefault();
      if (dragged && dragged !== this) {
        const children = Array.from(container.children);
        const draggedIndex = children.indexOf(dragged);
        const targetIndex = children.indexOf(this);
        if (draggedIndex < targetIndex) {
          container.insertBefore(dragged, this.nextSibling);
        } else {
          container.insertBefore(dragged, this);
        }
      }
    });
  });
}

document.addEventListener("DOMContentLoaded", function () {
  makeDraggable(".draggable");
});
</script>

<script>
function togglePin(button, cardId, innerId) {
  const card = document.getElementById(cardId);
  const inner = document.getElementById(innerId);
  const label = button.nextElementSibling;

  if (inner.classList.contains("pinned")) {
    inner.classList.remove("pinned");
    card.classList.remove("pinned");
    label.textContent = "Pin to stop flip";
    button.textContent = "📌";
  } else {
    inner.classList.add("pinned");
    card.classList.add("pinned");
    label.textContent = "Unpin to allow flip";
    button.textContent = "📍";
  }
}
</script>


<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels"></script>
<script>
function toggleDashboardCards() {
  const dash = document.getElementById("dashboard");
  const filters = document.getElementById("dashboardFilters");
  const charts = document.getElementById("dashboardCharts");
  const btn = document.getElementById("dashToggleBtnTop");

  dash.classList.toggle("dashboard-hidden");
  filters.classList.toggle("dashboard-filters-hidden");
  charts.classList.toggle("dashboard-charts-hidden");
  charts.classList.toggle("dashboard-chart-wrapper-hidden");

  const isHidden = dash.classList.contains("dashboard-hidden");
  btn.textContent = isHidden ? "Show Dashboard" : "Hide Dashboard";
  localStorage.setItem("dashboardVisible", isHidden ? "hidden" : "visible");

  if (!isHidden) {
    window.scrollTo({ top: 0, behavior: 'smooth' });
  }
}

document.addEventListener("DOMContentLoaded", function () {
  const dash = document.getElementById("dashboard");
  const filters = document.getElementById("dashboardFilters");
  const charts = document.getElementById("dashboardCharts");
  const btn = document.getElementById("dashToggleBtnTop");

  const dashState = localStorage.getItem("dashboardVisible");
  const isInitiallyHidden = dashState === "hidden";

  if (isInitiallyHidden) {
    dash.classList.add("dashboard-hidden");
    filters.classList.add("dashboard-filters-hidden");
    charts.classList.add("dashboard-charts-hidden", "dashboard-chart-wrapper-hidden");
    btn.textContent = "Show Dashboard";
  }
});

function togglePin(button, cardId, innerId) {
  const card = document.getElementById(cardId);
  const inner = document.getElementById(innerId);
  const label = button.nextElementSibling;

  if (inner.classList.contains("pinned")) {
    inner.classList.remove("pinned");
    card.classList.remove("pinned");
    label.textContent = "Pin to stop flip";
    button.textContent = "📌";
  } else {
    inner.classList.add("pinned");
    card.classList.add("pinned");
    label.textContent = "Unpin to allow flip";
    button.textContent = "📍";
  }
}

function toggleUserPostedChart() {
  const chart = document.getElementById("dashboardCharts");
  const filtersToHide = [
    document.getElementById("filterAll"),
    document.getElementById("filterMonth"),
    document.getElementById("filter12mo"),
    document.getElementById("downloadBtn")
  ];
  const btn = document.getElementById("toggleChartBtn");

  const isHidden = chart.classList.toggle("dashboard-charts-hidden");
  chart.classList.toggle("dashboard-chart-wrapper-hidden");

  filtersToHide.forEach(el => {
    if (isHidden) {
      el.classList.add("dashboard-buttons-hidden");
    } else {
      el.classList.remove("dashboard-buttons-hidden");
    }
  });

  btn.textContent = isHidden ? "📊 Show Chart" : "📉 Hide Chart";
}
</script>


<script>
document.addEventListener("DOMContentLoaded", function () {
  // 🟦 General Dropdown Toggle by ID (works for userMenuDropdown or profileDropdown)
  window.toggleDropdownById = function (dropdownId, toggleBtnClass = "") {
    const dropdown = document.getElementById(dropdownId);
    if (!dropdown) return;
    dropdown.style.display = (dropdown.style.display === "block") ? "none" : "block";

    // Optional: auto-close when clicking outside
    document.addEventListener("click", function (event) {
      const toggleBtn = toggleBtnClass ? document.querySelector(toggleBtnClass) : null;
      if (!dropdown.contains(event.target) && (!toggleBtn || !toggleBtn.contains(event.target))) {
        dropdown.style.display = "none";
      }
    }, { once: true });
  };

  // 🔐 Login/Logout Button Visibility (PHP-controlled)
  const isLoggedIn = <?= json_encode(isLogged()); ?>;
  const loginBtn = document.getElementById("loginform_login");
  const logoutBtn = document.getElementById("logout_link");

  if (loginBtn && logoutBtn) {
    if (isLoggedIn) {
      loginBtn.style.display = "none";
      logoutBtn.style.display = "inline-block";
    } else {
      loginBtn.style.display = "inline-block";
      logoutBtn.style.display = "none";
    }
  }

  // 🧩 Shorthand for user menu toggle
  window.toggleUserMenu = function () {
    toggleDropdownById("userMenuDropdown", ".dropdown-toggle");
  };

  window.closeUserMenu = function () {
    const menu = document.getElementById("userMenuDropdown");
    if (menu) menu.style.display = "none";
  };

  // 👤 Optional: support a separate profile dropdown toggle
  window.toggleProfileDropdown = function (event) {
    event.stopPropagation();
    toggleDropdownById("profileDropdown", ".dropdown-btn");
  };
});
</script>

<script>
  function applyTheme(theme) {
    const body = document.body;
    const btn = document.getElementById("themeToggleBtn");
    if (theme === "dark") {
      body.classList.add("dark-mode");
      btn.classList.add("active");
    } else {
      body.classList.remove("dark-mode");
      btn.classList.remove("active");
    }
    localStorage.setItem("theme", theme);
  }

  function toggleTheme() {
    const isDark = document.body.classList.contains("dark-mode");
    applyTheme(isDark ? "light" : "dark");
  }

  document.addEventListener("DOMContentLoaded", () => {
    const saved = localStorage.getItem("theme") || "light";
    applyTheme(saved);
    document.getElementById("themeToggleBtn").addEventListener("click", toggleTheme);
  });
</script>


<!-- script frpm Bitsilution SSO -->

<!-- Contact Form Modal - place at END of your <body> -->
<div id="email-form-container">
  <div class="email-form-box">
    <button id="hideEmailBtn" class="close-btn" title="Close">&times;</button>
    <h3>Contact Us</h3>
    <form id="emailForm" autocomplete="off">
      <input type="text" name="name" placeholder="Your Name" required><br>
      <input type="email" name="email" placeholder="Your Email" required><br>
      <select name="subject" style="width:94%;margin:8px 0;">
        <option value="">Select Subject</option>
        <option value="General Enquiry">General Enquiry</option>
        <option value="Support Request">Support Request</option>
        <option value="Partnership">Partnership</option>
        <option value="Other">Other</option>
      </select><br>
      <textarea name="message" placeholder="Your Message" rows="5" required></textarea><br>
      <button type="submit">Send</button>
    </form>
    <div id="emailMsg" style="margin-top:10px;"></div>
  </div>
  <div id="successBalloon" style="display:none;position:absolute;left:50%;top:50%;transform:translate(-50%,0);font-size:2.5em;pointer-events:none;z-index:2000;">🎈</div>
  <div id="splashThankYou" style="display:none;position:absolute;left:50%;top:45%;transform:translate(-50%,-50%);font-size:1.7em;color:#008800;font-weight:bold;z-index:2000;">Thank you! 🎉</div>
</div>


<script>
// Matrix code background
const canvas = document.getElementById('matrix-bg');
const ctx = canvas.getContext('2d');
let w = canvas.width = window.innerWidth;
let h = canvas.height = window.innerHeight;
const letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789@#$%^&*";
const fontSize = 18;
const columns = Math.floor(w / fontSize);
const drops = Array(columns).fill(1);

function drawMatrix() {
    ctx.fillStyle = "rgba(0,0,0,0.30)";
    ctx.fillRect(0, 0, w, h);

    ctx.font = fontSize + "px monospace";
    ctx.fillStyle = "#00ff57";
    for (let i = 0; i < drops.length; i++) {
        const text = letters.charAt(Math.floor(Math.random() * letters.length));
        ctx.fillText(text, i * fontSize, drops[i] * fontSize);

        if (drops[i] * fontSize > h && Math.random() > 0.975) drops[i] = 0;
        drops[i]++;
    }
}

setInterval(drawMatrix, 140);

window.addEventListener('resize', () => {
    w = canvas.width = window.innerWidth;
    h = canvas.height = window.innerHeight;
});
</script>
<script>
// Display years and days since founding
function updateSinceFounded() {
    const founded = new Date("2012-11-20T00:00:00+13:00");
    const now = new Date();
    // Calculate total days
    const msPerDay = 1000 * 60 * 60 * 24;
    const days = Math.floor((now - founded) / msPerDay);
    // Calculate years and remaining days
    let years = now.getFullYear() - founded.getFullYear();
    let anniversary = new Date(founded);
    anniversary.setFullYear(now.getFullYear());
    if (now < anniversary) years--;
    anniversary.setFullYear(founded.getFullYear() + years);
    const daysSinceAnniversary = Math.floor((now - anniversary) / msPerDay);

    document.getElementById('since-founded').innerText =
        `Serving Samoa and the Pacific for ${years} years and ${daysSinceAnniversary} days (since Nov 20, 2012)`;
}
updateSinceFounded();
setInterval(updateSinceFounded, 3600 * 1000); // Update every hour
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const popup = document.createElement('div');
    popup.className = 'preview-popup';
    document.body.appendChild(popup);

    let hideTimeout;

    function closePopup() {
        popup.classList.add('hide');
        setTimeout(() => {
            popup.style.display = 'none';
            popup.classList.remove('hide');
        }, 220); // match fadeOutPopup animation duration
    }

    function showPopup(link) {
        clearTimeout(hideTimeout);
        const title = link.dataset.previewTitle || '';
        const htmlContent = link.dataset.previewHtml || '';
        const textContent = link.dataset.previewText || '';
        const mapLink = link.dataset.previewLink || '';

        // Close button HTML
        let closeBtn = `<button class="popup-close" aria-label="Close preview" tabindex="0">&times;</button>`;

        let inner = closeBtn;
        inner += title ? `<strong>${title}</strong><br>` : '';
        if (htmlContent) {
            inner += htmlContent;
        } else if (textContent) {
            inner += textContent;
            if (mapLink) {
                inner += `<br><a href="${mapLink}" target="_blank">View on Google Maps</a>`;
            }
        }
        popup.innerHTML = inner;
        popup.style.display = 'block';
        popup.scrollTop = 0;

        // Positioning
        const rect = link.getBoundingClientRect();
        let top = window.scrollY + rect.bottom + 8;
        let left = window.scrollX + rect.left;

        popup.style.maxHeight = '350px';
        popup.style.overflowY = 'auto';
        popup.style.width = '';
        popup.style.transform = '';
        popup.style.bottom = '';

        // Mobile: center and stick to bottom if screen is narrow
        if (window.innerWidth < 600) {
            popup.style.left = '50%';
            popup.style.top = '';
            popup.style.bottom = '10px';
            popup.style.transform = 'translateX(-50%)';
            popup.style.width = '96vw';
        } else {
            popup.style.top = `${top}px`;
            popup.style.left = `${left}px`;
            popup.style.width = '';
            popup.style.transform = '';
            popup.style.bottom = '';

            // Ensure popup stays in viewport (scroll up if needed)
            setTimeout(() => {
                const popupRect = popup.getBoundingClientRect();
                const overflow = (popupRect.bottom > window.innerHeight) ? (popupRect.bottom - window.innerHeight + 14) : 0;
                if (overflow > 0) {
                    popup.style.top = `${top - overflow}px`;
                }
            }, 10);
        }

        // Handle close button click
        popup.querySelector('.popup-close').onclick = closePopup;
    }

    document.querySelectorAll('.preview-link').forEach(link => {
        link.addEventListener('mouseenter', function(e) {
            showPopup(link);
        });
        link.addEventListener('focus', function(e) {
            showPopup(link);
        });
        link.addEventListener('mouseleave', function() {
            hideTimeout = setTimeout(closePopup, 180);
        });
        link.addEventListener('blur', function() {
            hideTimeout = setTimeout(closePopup, 180);
        });
    });

    popup.addEventListener('mouseenter', function() {
        clearTimeout(hideTimeout);
    });
    popup.addEventListener('mouseleave', function() {
        closePopup();
    });

    // Allow keyboard ESC to close the popup
    document.addEventListener('keydown', function(e) {
        if (popup.style.display === 'block' && (e.key === "Escape" || e.keyCode === 27)) {
            closePopup();
        }
    });
});
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tooltip creation
    let donorTooltip = document.createElement('div');
    donorTooltip.className = 'donor-tooltip';
    donorTooltip.tabIndex = 0; // For accessibility
    document.body.appendChild(donorTooltip);

    let tooltipTimeout;
    let currentTarget = null;

    // Show the tooltip
    function showTooltip(target) {
        currentTarget = target;
        const previewText = target.dataset.previewText || '';
        const previewUrl = target.dataset.previewUrl || target.href;
        const title = target.dataset.previewTitle || target.textContent;
        // Tooltip HTML with close icon
        donorTooltip.innerHTML = `
            <button class="donor-tooltip-close" aria-label="Close preview" tabindex="0">&times;</button>
            <strong>${title}</strong><br>${previewText}<br>
            <a href="#" class="donor-tooltip-visit" data-preview-title="${title}" data-preview-url="${previewUrl}" tabindex="0">Visit Website</a>
        `;
        donorTooltip.style.display = 'block';
        donorTooltip.style.opacity = '1';

        // Position below link
        let rect = target.getBoundingClientRect();
        donorTooltip.style.top = (window.scrollY + rect.bottom + 6) + 'px';
        donorTooltip.style.left = (window.scrollX + rect.left) + 'px';
    }

    // Hide the tooltip
    function hideTooltip() {
        donorTooltip.style.opacity = '0';
        tooltipTimeout = setTimeout(() => {
            donorTooltip.style.display = 'none';
        }, 160);
    }

    // Keep tooltip visible when mouse enters, hide when leaves both link and tooltip
    document.body.addEventListener('mouseover', function(e) {
        if (e.target.classList.contains('donor-preview')) {
            clearTimeout(tooltipTimeout);
            showTooltip(e.target);
        }
    });
    document.body.addEventListener('mouseout', function(e) {
        if (e.target.classList.contains('donor-preview')) {
            tooltipTimeout = setTimeout(hideTooltip, 180);
        }
    });
    donorTooltip.addEventListener('mouseenter', function() {
        clearTimeout(tooltipTimeout);
    });
    donorTooltip.addEventListener('mouseleave', function() {
        hideTooltip();
    });

    // Tooltip close icon
    donorTooltip.addEventListener('click', function(e) {
        if (e.target.classList.contains('donor-tooltip-close')) {
            hideTooltip();
        }
        // Intercept "Visit Website" click to open modal (if using modal for iframe preview)
        if (e.target.classList.contains('donor-tooltip-visit')) {
            e.preventDefault();
            const title = e.target.dataset.previewTitle;
            const url = e.target.dataset.previewUrl;
            // You can call your openDonorModal(title, url) function here if needed
            if (typeof openDonorModal === 'function') openDonorModal(title, url);
            hideTooltip();
        }
    });

    // ESC closes tooltip if focused
    donorTooltip.addEventListener('keydown', function(e) {
        if (e.key === "Escape" || e.keyCode === 27) {
            hideTooltip();
        }
    });
});
</script>


<script>
document.addEventListener('DOMContentLoaded', function() {
    // --- Modal Element References ---
    const modal = document.getElementById('donor-modal');
    const modalHeader = modal.querySelector('.donor-modal-header');
    const modalIframe = modal.querySelector('.donor-modal-iframe');
    const closeModalBtn = modal.querySelector('.donor-modal-close');
    const fallbackDiv = modal.querySelector('.modal-fallback');
    const modalContent = modal.querySelector('.donor-modal-content');

    // --- Modal Open/Close Functions ---
    function openDonorModal(title, url) {
        modalHeader.textContent = title;
        modalIframe.src = url;
        modalIframe.style.display = '';
        fallbackDiv.style.display = 'none';
        fallbackDiv.innerHTML = '';
        modal.style.display = 'flex';
        document.body.style.overflow = 'hidden';

        // Fallback: show external link if iframe does not load after 2.2 seconds
        setTimeout(function() {
            // Check if modal is still open and iframe hasn't been interacted with
            if (modal.style.display === 'flex') {
                // Try to detect blank iframe (some browsers block access to contents)
                // If you want to be more robust, always show fallback for known domains
                modalIframe.style.display = 'none';
                fallbackDiv.style.display = 'block';
                fallbackDiv.innerHTML = `
                    <p>Sorry, this website does not allow preview inside other sites.</p>
                    <a href="${url}" target="_blank" class="visit-in-new-tab">Open in New Tab</a>
                `;
            }
        }, 2200);

        // Optional: clear fallback if iframe loads successfully
        modalIframe.onload = function() {
            // Some sites may still block, but if iframe loads, show it
            fallbackDiv.style.display = 'none';
            modalIframe.style.display = '';
        };
        // Optional: show fallback immediately if iframe errors
        modalIframe.onerror = function() {
            modalIframe.style.display = 'none';
            fallbackDiv.style.display = 'block';
            fallbackDiv.innerHTML = `
                <p>Sorry, this website does not allow preview inside other sites.</p>
                <a href="${url}" target="_blank" class="visit-in-new-tab">Open in New Tab</a>
            `;
        };
    }

    function closeDonorModal() {
        modal.style.display = 'none';
        modalIframe.src = '';
        fallbackDiv.style.display = 'none';
        fallbackDiv.innerHTML = '';
        document.body.style.overflow = '';
    }

    // --- Modal Close Listeners ---
    closeModalBtn.addEventListener('click', closeDonorModal);
    modal.addEventListener('click', function(e) {
        if (e.target === modal) closeDonorModal();
    });
    document.addEventListener('keydown', function(e) {
        if (modal.style.display === 'flex' && (e.key === "Escape" || e.keyCode === 27)) {
            closeDonorModal();
        }
    });

    // --- Listen for Donor Preview Link Clicks ---
    document.body.addEventListener('click', function(e) {
        // For .donor-preview links (in popup or tooltip)
        if (e.target.classList.contains('donor-preview') || e.target.classList.contains('donor-tooltip-visit')) {
            e.preventDefault();
            const title = e.target.dataset.previewTitle || e.target.textContent;
            const url = e.target.dataset.previewUrl || e.target.href;
            openDonorModal(title, url);
            // Also hide any open tooltip (optional)
            if (window.donorTooltip) {
                window.donorTooltip.style.display = 'none';
            }
        }
    });
});
</script>


<script>
document.addEventListener('DOMContentLoaded', function() {
    const loginBox = document.getElementById('loginBox');
    const hideLoginBtn = document.getElementById('hideLoginBtn');
    const showLoginBtn = document.getElementById('showLoginBtn');

    hideLoginBtn.onclick = function() {
        loginBox.style.display = 'none';
        hideLoginBtn.style.display = 'none';
        showLoginBtn.style.display = 'inline-block';
    };
    showLoginBtn.onclick = function() {
        loginBox.style.display = 'flex'; // or 'block' depending on your CSS
        hideLoginBtn.style.display = 'inline-block';
        showLoginBtn.style.display = 'none';
    };
});
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
  // Open modal
  var showBtn = document.getElementById('showEmailBtn');
  if(showBtn){
    showBtn.onclick = function() {
      document.getElementById('email-form-container').classList.add('active');
	  document.querySelector('.content-container').classList.add('fade-blur'); //latest
    };
  }
  // Close modal
  document.getElementById('hideEmailBtn').onclick = closeModal;

  // Click outside form closes modal
  document.getElementById('email-form-container').addEventListener('click', function(e){
    if(e.target === this) closeModal();
  });

  function closeModal() {
    document.getElementById('email-form-container').classList.remove('active');
	document.querySelector('.content-container').classList.remove('fade-blur');
    setTimeout(function(){
      document.getElementById('emailMsg').textContent = '';
      document.getElementById('emailForm').reset();
    }, 300);
  }

  // AJAX form send
  document.getElementById('emailForm').onsubmit = function(e) {
    e.preventDefault();
    var formData = new FormData(this);
    fetch('send_email.php', {
      method: 'POST',
      body: formData
    })
    .then(response => response.text())
    .then(result => {
      if(result.trim() === "success") {
        document.getElementById('emailMsg').textContent =
          "Thank you for contacting us! If your email address is valid, we will respond to you shortly. We appreciate your interest and your visit to our website. You may now close this form. Thank you.";
		  
  // Show balloon
  var balloon = document.getElementById('successBalloon');
  if(balloon){
    balloon.classList.add('show');
    setTimeout(function(){ balloon.classList.remove('show'); }, 4000);
  }

  // Show splash
  var splash = document.getElementById('splashThankYou');
  if(splash){
    splash.classList.add('show');
    setTimeout(function(){ splash.classList.remove('show'); }, 4000);
  }

  setTimeout(closeModal, 8000); // Auto-close after 6 sec
      } else if(result.trim() === "fail") {
        document.getElementById('emailMsg').textContent =
          "Sorry, your message could not be sent. Please try again later.";
      } else if(result.trim() === "invalid") {
        document.getElementById('emailMsg').textContent =
          "Please fill out all fields correctly.";
      } else {
        document.getElementById('emailMsg').textContent = result;
      }
    });
  };
});
</script>

<!-- Place this just before </body> -->
<!-- <button id="openChatBtn" style="position:fixed;bottom:24px;right:24px;z-index:9999;padding:12px 18px;background:#3388ff;color:#fff;border:none;border-radius:25px;font-weight:bold;box-shadow:0 2px 8px #0002;">💬 Chat</button>
<div id="floatingChat" style="display:none;position:fixed;left:50%;top:50%;transform:translate(-50%,-50%);z-index:9999;width:340px;max-width:98vw;box-shadow:0 4px 32px #0003;background:#fff;border-radius:12px;">
    <div style="display:flex;justify-content:space-between;align-items:center;padding:12px 18px 0;">
        <strong style="color:#3388ff;font-size:1.1em;">Live Chat</strong>
        <button id="closeChatBtn" style="font-size:1.6em;line-height:1;color:#3388ff;background:none;border:none;cursor:pointer;">&times;</button>
    </div>
    <div id="chatMessages" style="height:200px;overflow-y:auto;border:1px solid #eee;margin:16px 10px 10px 10px;border-radius:6px;background:#fafbfc;"></div>
    <form id="chatForm" autocomplete="off" style="display:flex;gap:8px;padding:10px;">
        <input id="chatInput" placeholder="Type your message..." autocomplete="off" style="flex:1;padding:6px;border-radius:4px;border:1px solid #ccc;" />
        <button type="submit" style="padding:6px 16px;border-radius:4px;border:none;background:#3388ff;color:#fff;font-weight:bold;">Send</button>
    </form> -->
	<!-- WhatsApp Button (Add this inside your #floatingChat) -->
<!--<div style="text-align:center; margin-bottom:10px;">
    <a href="https://wa.me/640277286825" target="_blank"
       style="display:inline-block;background:#25d366;color:white;font-weight:bold;padding:8px 18px;border-radius:5px;text-decoration:none;font-size:1em;">
        <img src="https://upload.wikimedia.org/wikipedia/commons/6/6b/WhatsApp.svg" alt="WhatsApp" style="width:1.4em;vertical-align:middle;margin-right:8px;">
        Chat on WhatsApp
    </a>
</div>
</div>-->


<script>
function getCookie(name) {
    const match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
    return match ? match[2] : null;
}

const sessionId = getCookie('PHPSESSID');
const chatBox = document.getElementById('chatMessages');
const chatForm = document.getElementById('chatForm');
const chatInput = document.getElementById('chatInput');
const openBtn = document.getElementById('openChatBtn');
const closeBtn = document.getElementById('closeChatBtn');
const chatWrapper = document.getElementById('floatingChat');
const contentContainer = document.querySelector('.content-container'); // Optional wrapper blur

// 🔄 Load messages from server
function loadMessages() {
    fetch('get_messages.php?session_id=' + encodeURIComponent(sessionId))
        .then(res => res.json())
        .then(messages => {
            chatBox.innerHTML = '';
            messages.forEach(m => {
                const div = document.createElement('div');
                if (m.sender === 'bot') {
                    div.innerHTML = `<strong style="color:#25d366">Bot:</strong> ${m.message}`;
                } else {
                    div.innerHTML = `<strong>You:</strong> ${escapeHTML(m.message)}`;
                }
                div.style.margin = '5px 10px';
                chatBox.appendChild(div);
            });
            chatBox.scrollTop = chatBox.scrollHeight;
        });
}

// ✉️ Send message to server
function sendMessage(sender, msg) {
    fetch('save_message.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: `sender=${encodeURIComponent(sender)}&message=${encodeURIComponent(msg)}&session_id=${encodeURIComponent(sessionId)}`
    }).then(loadMessages);
}

// 🔒 Escape user HTML to avoid injection
function escapeHTML(str) {
    return str.replace(/[&<>"']/g, tag => ({
        '&': '&amp;', '<': '&lt;', '>': '&gt;', '"': '&quot;', "'": '&#39;'
    }[tag]));
}

// ▶️ Open chat
openBtn.onclick = () => {
    chatWrapper.style.display = 'block';
    openBtn.style.display = 'none';
    chatInput.focus();
    if (contentContainer) contentContainer.classList.add('fade-blur');

    if (!sessionStorage.getItem('bot_welcome_sent')) {
        sendMessage('bot', `Talofa! How can I help you? For urgent support, you can also <a href="https://wa.me/640277286825" target="_blank" style="color:#25d366;font-weight:bold;">chat with us on WhatsApp</a>.`);
        sessionStorage.setItem('bot_welcome_sent', '1');
    }
};

// ❌ Close chat
closeBtn.onclick = () => {
    chatWrapper.style.display = 'none';
    openBtn.style.display = 'inline-block';
    if (contentContainer) contentContainer.classList.remove('fade-blur');
};

// ⌨️ On submit
chatForm.onsubmit = e => {
    e.preventDefault();
    const msg = chatInput.value.trim();
    if (msg) {
        sendMessage('visitor', msg);
        chatInput.value = '';
    }
};

// 🔁 Auto-refresh
setInterval(loadMessages, 2000);
loadMessages();
</script>




<script>
document.getElementById('openPortfolioBtn').onclick = function() {
    var modal = document.getElementById('portfolioModal');
    var content = document.getElementById('portfolioContent');
    modal.style.display = 'flex';
    content.innerHTML = '<div style="text-align:center;padding:40px;">Loading projects...</div>';
    fetch('portfolio_content.php')
        .then(res => res.text())
        .then(html => {
            content.innerHTML = html;
        })
        .catch(() => {
            content.innerHTML = '<div style="text-align:center;padding:40px;color:#d32f2f;">Failed to load portfolio.</div>';
        });
    // Optional: blur background if you like
    document.body.classList.add('fade-blur');
};
// Close modal
document.getElementById('closePortfolioBtn').onclick = function() {
    document.getElementById('portfolioModal').style.display = 'none';
    document.body.classList.remove('fade-blur');
};
// Click outside modal to close
document.getElementById('portfolioModal').onclick = function(e) {
    if(e.target === this) {
        this.style.display = 'none';
        document.body.classList.remove('fade-blur');
    }
};
// ESC closes modal
document.addEventListener('keydown', function(e){
    if(e.key === "Escape" || e.keyCode === 27) {
        document.getElementById('portfolioModal').style.display = 'none';
        document.body.classList.remove('fade-blur');
    }
});
</script>


</body>
</html>
